/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.lib;

import java.util.HashMap;
import java.util.Map;

public class StringAbbrev {
    Map<String, String> prefix2string = new HashMap<String, String>();

    public StringAbbrev() {
        this.prefix2string.put("_", ":");
    }

    public void add(String prefix, String string) {
        if (prefix.contains(":")) {
            throw new IllegalArgumentException("Prefix contains ':' -- " + prefix);
        }
        if (prefix.equals("")) {
            throw new IllegalArgumentException("Prefix is the empty string");
        }
        this.prefix2string.put(prefix, string);
    }

    public String abbreviate(String s2) {
        for (Map.Entry<String, String> e2 : this.prefix2string.entrySet()) {
            String prefix = e2.getKey();
            String string = e2.getValue();
            if (!((String)s2).startsWith(string)) continue;
            String s22 = ":" + prefix + ":" + ((String)s2).substring(string.length());
            return s22;
        }
        if (((String)s2).startsWith(":")) {
            s2 = ":" + (String)s2;
        }
        return s2;
    }

    public String expand(String s2) {
        if (!s2.startsWith(":")) {
            return s2;
        }
        int i = s2.indexOf(":", 1);
        if (i < 0) {
            return s2;
        }
        if (i == 1) {
            return s2.substring(1);
        }
        String prefix = s2.substring(1, i);
        if (prefix == null) {
            return s2.substring(i + 1);
        }
        String start = this.prefix2string.get(prefix);
        return start + s2.substring(i + 1);
    }
}

