/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.core.JsonLdTripleCallback;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;

@Deprecated
public class LangJSONLD10
implements ReaderRIOT {
    private static final String SYMBOLS_NS = "http://jena.apache.org/riot/jsonld#";
    public static final Symbol JSONLD_CONTEXT = SystemARQ.allocSymbol("http://jena.apache.org/riot/jsonld#", "JSONLD_CONTEXT");
    public static final Symbol JSONLD_OPTIONS = SystemARQ.allocSymbol("http://jena.apache.org/riot/jsonld#", "JSONLD_OPTIONS");
    private ErrorHandler errorHandler = ErrorHandlerFactory.getDefaultErrorHandler();
    private ParserProfile profile;
    public static String LITERAL = "literal";
    public static String BLANK_NODE = "blank node";
    public static String IRI = "IRI";
    private static final String xsdString = XSDDatatype.XSDstring.getURI();

    public LangJSONLD10(Lang lang, ParserProfile profile, ErrorHandler errorHandler) {
        this.profile = profile;
        this.errorHandler = errorHandler;
    }

    @Override
    public void read(Reader reader, String baseURI, ContentType ct, StreamRDF output, Context context2) {
        try {
            Object jsonObject = JsonUtils.fromReader(reader);
            this.readWithJsonLDCtxOptions(jsonObject, baseURI, output, context2);
        }
        catch (JsonProcessingException ex) {
            JsonLocation loc = ex.getLocation();
            this.errorHandler.error(ex.getOriginalMessage(), loc.getLineNr(), loc.getColumnNr());
            throw new RiotException(ex.getOriginalMessage());
        }
        catch (IOException e2) {
            this.errorHandler.error(e2.getMessage(), -1L, -1L);
            IO.exception(e2);
        }
    }

    @Override
    public void read(InputStream in, String baseURI, ContentType ct, StreamRDF output, Context context2) {
        try {
            Object jsonObject = JsonUtils.fromInputStream(in);
            this.readWithJsonLDCtxOptions(jsonObject, baseURI, output, context2);
        }
        catch (JsonProcessingException ex) {
            JsonLocation loc = ex.getLocation();
            this.errorHandler.error(ex.getOriginalMessage(), loc.getLineNr(), loc.getColumnNr());
            throw new RiotException(ex.getOriginalMessage());
        }
        catch (IOException e2) {
            this.errorHandler.error(e2.getMessage(), -1L, -1L);
            IO.exception(e2);
        }
    }

    private void readWithJsonLDCtxOptions(Object jsonObject, String baseURI, StreamRDF output, Context context2) throws JsonParseException, IOException {
        JsonLdOptions options = LangJSONLD10.getJsonLdOptions(baseURI, context2);
        Object jsonldCtx = LangJSONLD10.getJsonLdContext(context2);
        if (jsonldCtx != null) {
            if (jsonObject instanceof Map) {
                ((Map)jsonObject).put("@context", jsonldCtx);
            } else {
                this.errorHandler.warning("Unexpected: not a Map; unable to set JsonLD's @context", -1L, -1L);
            }
        }
        this.read$(jsonObject, options, output);
    }

    private void read$(Object jsonObject, JsonLdOptions options, final StreamRDF output) {
        output.start();
        try {
            JsonLdTripleCallback callback = new JsonLdTripleCallback(){

                @Override
                public Object call(RDFDataset dataset) {
                    for (Map.Entry<String, String> namespace2 : dataset.getNamespaces().entrySet()) {
                        output.prefix(namespace2.getKey(), namespace2.getValue());
                    }
                    for (String gn : dataset.keySet()) {
                        Object x = dataset.get(gn);
                        if ("@default".equals(gn)) {
                            List triples = (List)x;
                            for (Map t2 : triples) {
                                Node s2 = LangJSONLD10.this.createNode(t2, "subject");
                                Node p = LangJSONLD10.this.createNode(t2, "predicate");
                                Node o = LangJSONLD10.this.createNode(t2, "object");
                                Triple triple = LangJSONLD10.this.profile.createTriple(s2, p, o, -1L, -1L);
                                output.triple(triple);
                            }
                            continue;
                        }
                        List quads = (List)x;
                        Node g2 = LangJSONLD10.this.createURI(gn);
                        for (Map q : quads) {
                            Node s3 = LangJSONLD10.this.createNode(q, "subject");
                            Node p = LangJSONLD10.this.createNode(q, "predicate");
                            Node o = LangJSONLD10.this.createNode(q, "object");
                            Quad quad = LangJSONLD10.this.profile.createQuad(g2, s3, p, o, -1L, -1L);
                            output.quad(quad);
                        }
                    }
                    return null;
                }
            };
            JsonLdProcessor.toRDF(jsonObject, callback, options);
        }
        catch (JsonLdError e2) {
            this.errorHandler.error(e2.getMessage(), -1L, -1L);
            throw new RiotException(e2);
        }
        output.finish();
    }

    private static JsonLdOptions getJsonLdOptions(String baseURI, Context jenaContext) {
        JsonLdOptions opts = (JsonLdOptions)jenaContext.get(JSONLD_OPTIONS);
        return opts != null ? opts : LangJSONLD10.defaultJsonLdOptions(baseURI);
    }

    private static JsonLdOptions defaultJsonLdOptions(String baseURI) {
        JsonLdOptions opts = new JsonLdOptions(baseURI);
        opts.useNamespaces = true;
        return opts;
    }

    private static Object getJsonLdContext(Context jenaContext) throws JsonParseException, IOException {
        Object o;
        Object ctx = null;
        boolean isCtxDefined = false;
        if (jenaContext != null && jenaContext.isDefined(JSONLD_CONTEXT) && (o = jenaContext.get(JSONLD_CONTEXT)) != null) {
            if (o instanceof String) {
                String jsonString = (String)o;
                o = JsonUtils.fromString(jsonString);
            }
            ctx = o;
        }
        return ctx;
    }

    private Node createNode(Map<String, Object> tripleMap, String key) {
        Map x = (Map)tripleMap.get(key);
        return this.createNode(x);
    }

    private Node createNode(Map<String, Object> map) {
        String type = (String)map.get("type");
        String lex = (String)map.get("value");
        if (type.equals(IRI)) {
            return this.createURI(lex);
        }
        if (type.equals(BLANK_NODE)) {
            return this.createBlankNode(lex);
        }
        if (type.equals(LITERAL)) {
            String lang = (String)map.get("language");
            String datatype = (String)map.get("datatype");
            if (Objects.equals(xsdString, datatype)) {
                datatype = null;
            }
            if (lang == null && datatype == null) {
                return this.profile.createStringLiteral(lex, -1L, -1L);
            }
            if (lang != null) {
                return this.profile.createLangLiteral(lex, lang, -1L, -1L);
            }
            RDFDatatype dt = NodeFactory.getType(datatype);
            return this.profile.createTypedLiteral(lex, dt, -1L, -1L);
        }
        throw new InternalErrorException("Node is not a IRI, bNode or a literal: " + type);
    }

    private Node createBlankNode(String str2) {
        if (str2.startsWith("_:")) {
            str2 = str2.substring(2);
        }
        return this.profile.createBlankNode(null, str2, -1L, -1L);
    }

    private Node createURI(String str2) {
        if (str2.startsWith("_:")) {
            return this.createBlankNode(str2);
        }
        return this.profile.createURI(str2, -1L, -1L);
    }
}

