/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfs;

import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdfs.engine.InfFindTriple;
import org.apache.jena.rdfs.engine.MatchRDFS;
import org.apache.jena.rdfs.setup.ConfigRDFS;
import org.apache.jena.sparql.graph.GraphWrapper;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public class GraphRDFS
extends GraphWrapper {
    private final MatchRDFS<Node, Triple> source;
    private final ConfigRDFS<Node> setup;

    public GraphRDFS(Graph graph, ConfigRDFS<Node> setup) {
        super(graph);
        this.setup = setup;
        this.source = new InfFindTriple(setup, graph);
    }

    @Override
    public ExtendedIterator<Triple> find(Triple m4) {
        return this.find(m4.getSubject(), m4.getPredicate(), m4.getObject());
    }

    @Override
    public ExtendedIterator<Triple> find(Node s2, Node p, Node o) {
        Stream<Triple> stream = this.source.match(s2, p, o);
        WrappedIterator<Triple> iter = WrappedIterator.ofStream(stream);
        return iter;
    }

    @Override
    public Stream<Triple> stream(Node s2, Node p, Node o) {
        return this.source.match(s2, p, o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Node s2, Node p, Node o) {
        try (ExtendedIterator<Triple> iter = this.find(s2, p, o);){
            boolean bl = iter.hasNext();
            return bl;
        }
    }

    @Override
    public boolean contains(Triple t2) {
        return this.contains(t2.getSubject(), t2.getPredicate(), t2.getObject());
    }

    @Override
    public int size() {
        return super.size();
    }

    @Override
    public boolean dependsOn(Graph other) {
        if (other == super.get()) {
            return true;
        }
        return super.dependsOn(other);
    }
}

