/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf.model.impl;

import java.util.Iterator;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.RSIterator;
import org.apache.jena.rdf.model.ReifiedStatement;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.ModelCom;
import org.apache.jena.rdf.model.impl.RSIteratorImpl;
import org.apache.jena.rdf.model.impl.ReifiedStatementImpl;
import org.apache.jena.rdf.model.impl.ReifierStd;
import org.apache.jena.util.iterator.ExtendedIterator;

public class ModelReifier {
    private ModelCom model;
    private static boolean copyingReifications = false;

    public ModelReifier(ModelCom model) {
        this.model = model;
    }

    public ReifiedStatement createReifiedStatement(Statement s2) {
        return this.createReifiedStatement(null, s2);
    }

    public ReifiedStatement createReifiedStatement(String uri, Statement s2) {
        return ReifiedStatementImpl.create(this.model, uri, s2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getAnyReifiedStatement(Statement s2) {
        RSIterator it = this.listReifiedStatements(s2);
        if (it.hasNext()) {
            try {
                ReifiedStatement reifiedStatement = it.nextRS();
                return reifiedStatement;
            }
            finally {
                it.close();
            }
        }
        return this.createReifiedStatement(s2);
    }

    public boolean isReified(FrontsTriple s2) {
        return ReifierStd.hasTriple(this.model.getGraph(), s2.asTriple());
    }

    public void removeAllReifications(FrontsTriple s2) {
        ReifierStd.remove(this.model.getGraph(), s2.asTriple());
    }

    public void removeReification(ReifiedStatement rs) {
        ReifierStd.remove(this.model.getGraph(), rs.asNode(), rs.getStatement().asTriple());
    }

    public RSIterator listReifiedStatements() {
        return new RSIteratorImpl((Iterator<ReifiedStatement>)this.findReifiedStatements());
    }

    public RSIterator listReifiedStatements(FrontsTriple s2) {
        return new RSIteratorImpl((Iterator<ReifiedStatement>)this.findReifiedStatements(s2.asTriple()));
    }

    public void noteIfReified(RDFNode s2, RDFNode p, RDFNode o) {
        if (copyingReifications) {
            this.noteIfReified(s2);
            this.noteIfReified(p);
            this.noteIfReified(o);
        }
    }

    private void noteIfReified(RDFNode n) {
        if (n.canAs(ReifiedStatement.class)) {
            ReifiedStatement rs = n.as(ReifiedStatement.class);
            this.createReifiedStatement(rs.getURI(), rs.getStatement());
        }
    }

    private ExtendedIterator<ReifiedStatement> findReifiedStatements() {
        return ReifierStd.allNodes(this.model.getGraph()).mapWith(n -> this.getRS((Node)n));
    }

    private ExtendedIterator<ReifiedStatement> findReifiedStatements(Triple t2) {
        return ReifierStd.allNodes(this.model.getGraph(), t2).mapWith(n -> this.getRS((Node)n));
    }

    private ReifiedStatement getRS(Node n) {
        return ReifiedStatementImpl.createExistingReifiedStatement(this.model, n);
    }
}

