/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.cmd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.cmd.Arg;

public class ArgDecl {
    boolean takesValue;
    List<String> names = new ArrayList<String>();
    public static final boolean HasValue = true;
    public static final boolean NoValue = false;

    public ArgDecl(boolean hasValue) {
        this.takesValue = hasValue;
    }

    public ArgDecl(boolean hasValue, String ... names) {
        this(hasValue);
        Arrays.asList(names).forEach(this::addName);
    }

    public void addName(String name) {
        if (!this.names.contains(name = ArgDecl.canonicalForm(name))) {
            this.names.add(name);
        }
    }

    public String getKeyName() {
        return this.names.get(0);
    }

    public List<String> getNames() {
        return this.names;
    }

    public Iterator<String> names() {
        return this.names.iterator();
    }

    public boolean takesValue() {
        return this.takesValue;
    }

    public boolean matches(Arg a) {
        String name = a.getName();
        return this.names.stream().anyMatch(name::equals);
    }

    public boolean matches(String arg) {
        arg = ArgDecl.canonicalForm(arg);
        return this.names.contains(arg);
    }

    public static String canonicalForm(String str2) {
        if (str2.startsWith("--")) {
            return str2.substring(2);
        }
        if (str2.startsWith("-")) {
            return str2.substring(1);
        }
        return str2;
    }
}

