/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import org.apache.jena.atlas.lib.Chars;
import org.apache.jena.atlas.lib.InternalErrorException;

public class Bytes {
    public static final byte[] hexDigitsUC = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    public static final byte[] hexDigitsLC = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    private Bytes() {
    }

    public static byte[] asUTF8bytes(String s2) {
        return s2.getBytes(StandardCharsets.UTF_8);
    }

    public static String fromUTF8bytes(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static int compare(byte[] x1, byte[] x2) {
        int n = Math.min(x1.length, x2.length);
        for (int i = 0; i < n; ++i) {
            byte b1 = x1[i];
            byte b2 = x2[i];
            if (b1 == b2) continue;
            return (b1 & 0xFF) - (b2 & 0xFF);
        }
        return x1.length - x2.length;
    }

    public static int compareByte(byte b1, byte b2) {
        return (b1 & 0xFF) - (b2 & 0xFF);
    }

    public static byte[] copyOf(byte[] bytes) {
        return Bytes.copyOf(bytes, 0, bytes.length);
    }

    public static byte[] copyOf(byte[] bytes, int start) {
        return Bytes.copyOf(bytes, start, bytes.length - start);
    }

    public static byte[] copyOf(byte[] bytes, int start, int length) {
        byte[] newByteArray = new byte[length];
        System.arraycopy(bytes, start, newByteArray, 0, length);
        return newByteArray;
    }

    public static byte[] intToBytes(int v) {
        byte[] bytes = new byte[4];
        Bytes.setInt(v, bytes);
        return bytes;
    }

    public static byte[] longToBytes(long v) {
        byte[] bytes = new byte[8];
        Bytes.setLong(v, bytes);
        return bytes;
    }

    public static final int getInt(byte[] b) {
        return Bytes.getInt(b, 0);
    }

    public static final int getInt(byte[] b, int idx) {
        return Bytes.assembleInt(b[idx + 0], b[idx + 1], b[idx + 2], b[idx + 3]);
    }

    public static final long getLong(byte[] b) {
        return Bytes.getLong(b, 0);
    }

    public static final long getLong(byte[] b, int idx) {
        return Bytes.assembleLong(b[idx + 0], b[idx + 1], b[idx + 2], b[idx + 3], b[idx + 4], b[idx + 5], b[idx + 6], b[idx + 7]);
    }

    public static final void setInt(int value, byte[] b) {
        Bytes.setInt(value, b, 0);
    }

    public static final void setInt(int x, byte[] b, int idx) {
        b[idx + 0] = (byte)(x >> 24 & 0xFF);
        b[idx + 1] = (byte)(x >> 16 & 0xFF);
        b[idx + 2] = (byte)(x >> 8 & 0xFF);
        b[idx + 3] = (byte)(x & 0xFF);
    }

    public static final void setLong(long value, byte[] b) {
        Bytes.setLong(value, b, 0);
    }

    public static final void setLong(long value, byte[] b, int idx) {
        int lo = (int)(value & 0xFFFFFFFFL);
        int hi = (int)(value >>> 32);
        Bytes.setInt(hi, b, idx);
        Bytes.setInt(lo, b, idx + 4);
    }

    public static byte[] packInt(int val) {
        byte[] valBytes = new byte[4];
        Bytes.setInt(val, valBytes, 0);
        return valBytes;
    }

    public static byte[] packLong(long val) {
        byte[] valBytes = new byte[8];
        Bytes.setLong(val, valBytes, 0);
        return valBytes;
    }

    private static int assembleInt(byte b3, byte b2, byte b1, byte b0) {
        return (b3 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | (b0 & 0xFF) << 0;
    }

    private static Long assembleLong(byte b7, byte b6, byte b5, byte b4, byte b3, byte b2, byte b1, byte b0) {
        return ((long)b7 & 0xFFL) << 56 | ((long)b6 & 0xFFL) << 48 | ((long)b5 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b3 & 0xFFL) << 24 | ((long)b2 & 0xFFL) << 16 | ((long)b1 & 0xFFL) << 8 | ((long)b0 & 0xFFL) << 0;
    }

    private static byte byte3(int x) {
        return (byte)(x >> 24);
    }

    private static byte byte2(int x) {
        return (byte)(x >> 16);
    }

    private static byte byte1(int x) {
        return (byte)(x >> 8);
    }

    private static byte byte0(int x) {
        return (byte)(x >> 0);
    }

    public static byte[] string2bytes(String x) {
        try {
            return x.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String bytes2string(byte[] x) {
        try {
            return new String(x, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static int toByteBuffer(CharSequence s2, ByteBuffer bb) {
        CharsetEncoder enc = Chars.allocEncoder();
        int x = Bytes.toByteBuffer(s2, bb, enc);
        Chars.deallocEncoder(enc);
        return x;
    }

    public static int toByteBuffer(CharSequence s2, ByteBuffer bb, CharsetEncoder enc) {
        int start = bb.position();
        CharBuffer cBuff = CharBuffer.wrap(s2);
        enc.reset();
        CoderResult r = enc.encode(cBuff, bb, true);
        if (r.isOverflow()) {
            throw new InternalErrorException("Bytes.toByteBuffer: encode overflow (1)");
        }
        r = enc.flush(bb);
        if (r.isOverflow()) {
            throw new InternalErrorException("Bytes.toByteBuffer: encode overflow (2)");
        }
        int finish = bb.position();
        return finish - start;
    }

    public static String fromByteBuffer(ByteBuffer bb) {
        CharsetDecoder dec = Chars.allocDecoder();
        String x = Bytes.fromByteBuffer(bb, dec);
        Chars.deallocDecoder(dec);
        return x;
    }

    public static String fromByteBuffer(ByteBuffer bb, CharsetDecoder dec) {
        if (bb.remaining() == 0) {
            return "";
        }
        dec.reset();
        CharBuffer cBuff = CharBuffer.allocate(bb.remaining());
        CoderResult r = dec.decode(bb, cBuff, true);
        if (r.isOverflow()) {
            throw new InternalErrorException("fromByteBuffer: decode overflow (1)");
        }
        r = dec.flush(cBuff);
        if (r.isOverflow()) {
            throw new InternalErrorException("fromByteBuffer: decode overflow (2)");
        }
        cBuff.flip();
        return cBuff.toString();
    }

    public static String asHex(byte[] bytes) {
        return Bytes.asHexUC(bytes);
    }

    public static String asHexUC(byte[] bytes) {
        return Bytes.asHex(bytes, 0, bytes.length, Chars.hexDigitsUC);
    }

    public static String asHexLC(byte[] bytes) {
        return Bytes.asHex(bytes, 0, bytes.length, Chars.hexDigitsLC);
    }

    public static String asHex(byte[] bytes, int start, int finish, char[] hexDigits) {
        StringBuilder sw = new StringBuilder(bytes.length * 2);
        for (int i = start; i < finish; ++i) {
            byte b = bytes[i];
            int hi = (b & 0xF0) >> 4;
            int lo = b & 0xF;
            sw.append(hexDigits[hi]);
            sw.append(hexDigits[lo]);
        }
        return sw.toString();
    }

    public static String asHex(byte b) {
        return Bytes.asHexUC(b);
    }

    public static String asHexUC(byte b) {
        return Bytes.asHex(b, Chars.hexDigitsUC);
    }

    public static String asHexLC(byte b) {
        return Bytes.asHex(b, Chars.hexDigitsLC);
    }

    private static String asHex(byte b, char[] hexDigits) {
        int hi = (b & 0xF0) >> 4;
        int lo = b & 0xF;
        char[] chars = new char[]{hexDigits[hi], hexDigits[lo]};
        return new String(chars);
    }

    public static int hexCharToInt(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException("Bad index char : " + c);
    }
}

