/*
 * Decompiled with CFR 0.152.
 */
package tdb.tools;

import arq.cmdline.CmdARQ;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.tdb.base.file.Location;
import org.apache.jena.tdb.base.record.Record;
import org.apache.jena.tdb.base.record.RecordFactory;
import org.apache.jena.tdb.index.IndexFactory;
import org.apache.jena.tdb.index.RangeIndex;
import org.apache.jena.tdb.index.bplustree.BPlusTree;
import org.apache.jena.tdb.sys.Names;
import tdb.cmdline.ModLocation;

public class dumpbpt
extends CmdARQ {
    ModLocation modLocation = new ModLocation();

    public static void main(String ... argv) {
        LogCtl.setLogging();
        new dumpbpt(argv).mainRun();
    }

    protected dumpbpt(String[] argv) {
        super(argv);
        super.addModule(this.modLocation);
    }

    @Override
    protected void processModulesAndArgs() {
        if (this.modVersion.getVersionFlag()) {
            this.modVersion.printVersionAndExit();
        }
        if (this.modLocation.getLocation() == null) {
            this.cmdError("Location required");
        }
        if (super.getPositional().size() == 0) {
            this.cmdError("No index specified");
        }
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " --loc=DIR IndexName";
    }

    @Override
    protected String getCommandName() {
        return Lib.className(this);
    }

    @Override
    protected void exec() {
        List<String> tripleIndexes = Arrays.asList(Names.tripleIndexes);
        List<String> quadIndexes = Arrays.asList(Names.quadIndexes);
        Location loc = this.modLocation.getLocation();
        for (String indexName : super.getPositional()) {
            String primary;
            if (indexName.length() == 3) {
                primary = "SPO";
            } else if (indexName.length() == 4) {
                primary = "GSPO";
            } else if (Objects.equals(indexName, "node2id")) {
                primary = "node2id";
            } else {
                this.cmdError("Wrong length: " + indexName);
                primary = null;
            }
            int keySubLen = 8;
            int keyUnitLen = indexName.length();
            int keyLength = keySubLen * keyUnitLen;
            int valueLength = 0;
            if (Objects.equals(indexName, "node2id") || Objects.equals(indexName, "prefix2id")) {
                keySubLen = 16;
                keyUnitLen = 1;
                keyLength = 16;
                valueLength = 8;
            }
            if (Objects.equals(indexName, "prefixIdx")) {
                primary = "GPU";
            }
            RecordFactory rf = new RecordFactory(keyLength, valueLength);
            RangeIndex rIndex = IndexFactory.buildRangeIndex(loc, indexName, rf);
            BPlusTree bpt = (BPlusTree)rIndex;
            System.out.println("---- Index contents");
            Iterator<Record> iter = bpt.iterator();
            if (!iter.hasNext()) {
                System.out.println("<<Empty>>");
            }
            while (iter.hasNext()) {
                Record r = iter.next();
                dumpbpt.printRecord("", System.out, r, keyUnitLen);
            }
            Iterator<Record> iterCheck = bpt.iterator();
            Record r1 = null;
            int i = 0;
            while (iterCheck.hasNext()) {
                Record r2 = iterCheck.next();
                ++i;
                if (r1 != null && !Record.keyLT(r1, r2)) {
                    System.err.println("key error@ " + i);
                    dumpbpt.printRecord("  ", System.err, r1, keyUnitLen);
                    dumpbpt.printRecord("  ", System.err, r2, keyUnitLen);
                }
                r1 = r2;
            }
        }
    }

    private static void printRecord(String label, PrintStream out, Record r, int keyUnitLen) {
        int keySubLen = r.getKey().length / keyUnitLen;
        if (label != null) {
            out.print(label);
        }
        for (int i = 0; i < keyUnitLen; ++i) {
            int k;
            if (i != 0) {
                out.print(" ");
            }
            for (int j = k = i * keySubLen; j < k + keySubLen; ++j) {
                out.printf("%02X", r.getKey()[j]);
            }
        }
        if (r.getValue() != null && r.getValue().length != 0) {
            out.print(" -> ");
            String s2 = Bytes.asHexUC(r.getValue());
            out.print(s2);
        }
        out.println();
    }
}

