/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.lucene.util.SuppressForbidden;
import org.apache.lucene.util.VectorUtilDefaultProvider;

interface VectorUtilProvider {
    public static final Logger LOG = Logger.getLogger(VectorUtilProvider.class.getName());
    public static final Runtime.Version VERSION_JDK8301190_FIXED = Runtime.Version.parse("20.0.2");

    public float dotProduct(float[] var1, float[] var2);

    public float cosine(float[] var1, float[] var2);

    public float squareDistance(float[] var1, float[] var2);

    public int dotProduct(byte[] var1, byte[] var2);

    public float cosine(byte[] var1, byte[] var2);

    public int squareDistance(byte[] var1, byte[] var2);

    public static VectorUtilProvider lookup(boolean testMode) {
        int runtimeVersion = Runtime.version().feature();
        if (runtimeVersion >= 20 && runtimeVersion <= 21) {
            if (VectorUtilProvider.isAffectedByJDK8301190()) {
                LOG.warning("Java runtime is using a buggy default locale; Java vector incubator API can't be enabled: " + Locale.getDefault());
                return new VectorUtilDefaultProvider();
            }
            if (!VectorUtilProvider.vectorModulePresentAndReadable()) {
                LOG.warning("Java vector incubator module is not readable. For optimal vector performance, pass '--add-modules jdk.incubator.vector' to enable Vector API.");
                return new VectorUtilDefaultProvider();
            }
            if (!testMode && VectorUtilProvider.isClientVM()) {
                LOG.warning("C2 compiler is disabled; Java vector incubator API can't be enabled");
                return new VectorUtilDefaultProvider();
            }
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                Class<?> cls = lookup.findClass("org.apache.lucene.util.VectorUtilPanamaProvider");
                MethodHandle constr = lookup.findConstructor(cls, MethodType.methodType(Void.TYPE, Boolean.TYPE));
                try {
                    return constr.invoke(testMode);
                }
                catch (UnsupportedOperationException uoe) {
                    LOG.warning("Java vector incubator API was not enabled. " + uoe.getMessage());
                    return new VectorUtilDefaultProvider();
                }
                catch (Error | RuntimeException e2) {
                    throw e2;
                }
                catch (Throwable th) {
                    throw new AssertionError((Object)th);
                }
            }
            catch (IllegalAccessException | NoSuchMethodException e3) {
                throw new LinkageError("VectorUtilPanamaProvider is missing correctly typed constructor", e3);
            }
            catch (ClassNotFoundException cnfe) {
                throw new LinkageError("VectorUtilPanamaProvider is missing in Lucene JAR file", cnfe);
            }
        }
        if (runtimeVersion >= 22) {
            LOG.warning("You are running with Java 22 or later. To make full use of the Vector API, please update Apache Lucene.");
        }
        return new VectorUtilDefaultProvider();
    }

    private static boolean vectorModulePresentAndReadable() {
        Optional<Module> opt = ModuleLayer.boot().modules().stream().filter(m4 -> m4.getName().equals("jdk.incubator.vector")).findFirst();
        if (opt.isPresent()) {
            VectorUtilProvider.class.getModule().addReads(opt.get());
            return true;
        }
        return false;
    }

    private static boolean isAffectedByJDK8301190() {
        return VERSION_JDK8301190_FIXED.compareToIgnoreOptional(Runtime.version()) > 0 && !Objects.equals("I", "i".toUpperCase(Locale.getDefault()));
    }

    @SuppressForbidden(reason="security manager")
    private static boolean isClientVM() {
        try {
            PrivilegedAction<Boolean> action = () -> System.getProperty("java.vm.info", "").contains("emulated-client");
            return AccessController.doPrivileged(action);
        }
        catch (SecurityException e2) {
            LOG.warning("SecurityManager denies permission to 'java.vm.info' system property, so state of C2 compiler can't be detected. In case of performance issues allow access to this property.");
            return false;
        }
    }
}

