/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.document;

import java.util.Arrays;
import java.util.Collection;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.PointInSetQuery;
import org.apache.lucene.search.PointRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;

public final class HalfFloatPoint
extends Field {
    public static final int BYTES = 2;

    public static float nextUp(float v) {
        if (Float.isNaN(v) || v == Float.POSITIVE_INFINITY) {
            return v;
        }
        short s2 = HalfFloatPoint.halfFloatToSortableShort(v);
        float r = HalfFloatPoint.sortableShortToHalfFloat(s2);
        if (r <= v) {
            r = HalfFloatPoint.sortableShortToHalfFloat((short)(s2 + 1));
        }
        return r;
    }

    public static float nextDown(float v) {
        if (Float.isNaN(v) || v == Float.NEGATIVE_INFINITY) {
            return v;
        }
        short s2 = HalfFloatPoint.halfFloatToSortableShort(v);
        float r = HalfFloatPoint.sortableShortToHalfFloat(s2);
        if (r >= v) {
            r = HalfFloatPoint.sortableShortToHalfFloat((short)(s2 - 1));
        }
        return r;
    }

    public static short halfFloatToSortableShort(float v) {
        return HalfFloatPoint.sortableShortBits(HalfFloatPoint.halfFloatToShortBits(v));
    }

    public static float sortableShortToHalfFloat(short bits) {
        return HalfFloatPoint.shortBitsToHalfFloat(HalfFloatPoint.sortableShortBits(bits));
    }

    private static short sortableShortBits(short s2) {
        return (short)(s2 ^ s2 >> 15 & Short.MAX_VALUE);
    }

    static short halfFloatToShortBits(float v) {
        int floatBits = Float.floatToIntBits(v);
        int sign = floatBits >>> 31;
        int exp = floatBits >>> 23 & 0xFF;
        int mantissa = floatBits & 0x7FFFFF;
        if (exp == 255) {
            exp = 31;
            mantissa >>>= 13;
        } else if (exp == 0) {
            mantissa = 0;
        } else if ((exp = exp - 127 + 15) >= 31) {
            exp = 31;
            mantissa = 0;
        } else if (exp <= 0) {
            int shift = 13 - exp + 1;
            if (shift >= 32) {
                exp = 0;
                mantissa = 0;
            } else {
                mantissa |= 0x800000;
                mantissa = HalfFloatPoint.roundShift(mantissa, shift);
                exp = mantissa >>> 10;
                mantissa &= 0x3FF;
            }
        } else {
            mantissa = HalfFloatPoint.roundShift(exp << 23 | mantissa, 13);
            exp = mantissa >>> 10;
            mantissa &= 0x3FF;
        }
        return (short)(sign << 15 | exp << 10 | mantissa);
    }

    static int roundShift(int i, int shift) {
        assert (shift > 0);
        i += 1 << shift - 1;
        i -= i >>> shift & 1;
        return i >>> shift;
    }

    static float shortBitsToHalfFloat(short s2) {
        int sign = s2 >>> 15;
        int exp = s2 >>> 10 & 0x1F;
        int mantissa = s2 & 0x3FF;
        if (exp == 31) {
            exp = 255;
            mantissa <<= 13;
        } else if (mantissa != 0 || exp != 0) {
            if (exp == 0) {
                int shift = Integer.numberOfLeadingZeros(mantissa) - 21;
                mantissa = mantissa << shift & 0x3FF;
                exp = exp - shift + 1;
            }
            exp = exp + 127 - 15;
            mantissa <<= 13;
        }
        return Float.intBitsToFloat(sign << 31 | exp << 23 | mantissa);
    }

    static void shortToSortableBytes(short value, byte[] result, int offset) {
        value = (short)(value ^ 0x8000);
        BitUtil.VH_BE_SHORT.set(result, offset, value);
    }

    static short sortableBytesToShort(byte[] encoded, int offset) {
        short x = BitUtil.VH_BE_SHORT.get(encoded, offset);
        return (short)(x ^ 0x8000);
    }

    private static FieldType getType(int numDims) {
        FieldType type = new FieldType();
        type.setDimensions(numDims, 2);
        type.freeze();
        return type;
    }

    @Override
    public void setFloatValue(float value) {
        this.setFloatValues(value);
    }

    public void setFloatValues(float ... point) {
        if (this.type.pointDimensionCount() != point.length) {
            throw new IllegalArgumentException("this field (name=" + this.name + ") uses " + this.type.pointDimensionCount() + " dimensions; cannot change to (incoming) " + point.length + " dimensions");
        }
        this.fieldsData = HalfFloatPoint.pack(point);
    }

    @Override
    public void setBytesValue(BytesRef bytes) {
        throw new IllegalArgumentException("cannot change value type from float to BytesRef");
    }

    @Override
    public Number numericValue() {
        if (this.type.pointDimensionCount() != 1) {
            throw new IllegalStateException("this field (name=" + this.name + ") uses " + this.type.pointDimensionCount() + " dimensions; cannot convert to a single numeric value");
        }
        BytesRef bytes = (BytesRef)this.fieldsData;
        assert (bytes.length == 2);
        return Float.valueOf(HalfFloatPoint.decodeDimension(bytes.bytes, bytes.offset));
    }

    private static BytesRef pack(float ... point) {
        if (point == null) {
            throw new IllegalArgumentException("point must not be null");
        }
        if (point.length == 0) {
            throw new IllegalArgumentException("point must not be 0 dimensions");
        }
        byte[] packed = new byte[point.length * 2];
        for (int dim = 0; dim < point.length; ++dim) {
            HalfFloatPoint.encodeDimension(point[dim], packed, dim * 2);
        }
        return new BytesRef(packed);
    }

    public HalfFloatPoint(String name, float ... point) {
        super(name, HalfFloatPoint.pack(point), (IndexableFieldType)HalfFloatPoint.getType(point.length));
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(" <");
        result.append(this.name);
        result.append(':');
        BytesRef bytes = (BytesRef)this.fieldsData;
        for (int dim = 0; dim < this.type.pointDimensionCount(); ++dim) {
            if (dim > 0) {
                result.append(',');
            }
            result.append(HalfFloatPoint.decodeDimension(bytes.bytes, bytes.offset + dim * 2));
        }
        result.append('>');
        return result.toString();
    }

    public static void encodeDimension(float value, byte[] dest, int offset) {
        HalfFloatPoint.shortToSortableBytes(HalfFloatPoint.halfFloatToSortableShort(value), dest, offset);
    }

    public static float decodeDimension(byte[] value, int offset) {
        return HalfFloatPoint.sortableShortToHalfFloat(HalfFloatPoint.sortableBytesToShort(value, offset));
    }

    public static Query newExactQuery(String field, float value) {
        return HalfFloatPoint.newRangeQuery(field, value, value);
    }

    public static Query newRangeQuery(String field, float lowerValue, float upperValue) {
        return HalfFloatPoint.newRangeQuery(field, new float[]{lowerValue}, new float[]{upperValue});
    }

    public static Query newRangeQuery(String field, float[] lowerValue, float[] upperValue) {
        PointRangeQuery.checkArgs(field, lowerValue, upperValue);
        return new PointRangeQuery(field, HalfFloatPoint.pack((float[])lowerValue).bytes, HalfFloatPoint.pack((float[])upperValue).bytes, lowerValue.length){

            @Override
            protected String toString(int dimension, byte[] value) {
                return Float.toString(HalfFloatPoint.decodeDimension(value, 0));
            }
        };
    }

    public static Query newSetQuery(String field, float ... values) {
        final float[] sortedValues = (float[])values.clone();
        Arrays.sort(sortedValues);
        final BytesRef encoded = new BytesRef(new byte[2]);
        return new PointInSetQuery(field, 1, 2, new PointInSetQuery.Stream(){
            int upto;

            @Override
            public BytesRef next() {
                if (this.upto == sortedValues.length) {
                    return null;
                }
                HalfFloatPoint.encodeDimension(sortedValues[this.upto], encoded.bytes, 0);
                ++this.upto;
                return encoded;
            }
        }){

            @Override
            protected String toString(byte[] value) {
                assert (value.length == 2);
                return Float.toString(HalfFloatPoint.decodeDimension(value, 0));
            }
        };
    }

    public static Query newSetQuery(String field, Collection<Float> values) {
        Float[] boxed = values.toArray(new Float[0]);
        float[] unboxed = new float[boxed.length];
        for (int i = 0; i < boxed.length; ++i) {
            unboxed[i] = boxed[i].floatValue();
        }
        return HalfFloatPoint.newSetQuery(field, unboxed);
    }
}

