/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.surround.query;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.spans.SpanOrQuery;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.queries.spans.SpanTermQuery;
import org.apache.lucene.queryparser.surround.query.BasicQueryFactory;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;

public class SpanNearClauseFactory {
    private IndexReader reader;
    private String fieldName;
    private HashMap<SpanQuery, Float> weightBySpanQuery;
    private BasicQueryFactory qf;

    public SpanNearClauseFactory(IndexReader reader, String fieldName, BasicQueryFactory qf) {
        this.reader = reader;
        this.fieldName = fieldName;
        this.weightBySpanQuery = new HashMap();
        this.qf = qf;
    }

    public IndexReader getIndexReader() {
        return this.reader;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public BasicQueryFactory getBasicQueryFactory() {
        return this.qf;
    }

    public int size() {
        return this.weightBySpanQuery.size();
    }

    public void clear() {
        this.weightBySpanQuery.clear();
    }

    protected void addSpanQueryWeighted(SpanQuery sq2, float weight) {
        Float w = this.weightBySpanQuery.get(sq2);
        w = w != null ? Float.valueOf(w.floatValue() + weight) : Float.valueOf(weight);
        this.weightBySpanQuery.put(sq2, w);
    }

    public void addTermWeighted(Term t2, float weight) throws IOException {
        SpanTermQuery stq = this.qf.newSpanTermQuery(t2);
        this.addSpanQueryWeighted(stq, weight);
    }

    public void addSpanQuery(Query q) {
        if (q.getClass() == MatchNoDocsQuery.class) {
            return;
        }
        if (!(q instanceof SpanQuery)) {
            throw new AssertionError((Object)("Expected SpanQuery: " + q.toString(this.getFieldName())));
        }
        float boost = 1.0f;
        this.addSpanQueryWeighted((SpanQuery)q, boost);
    }

    public SpanQuery makeSpanClause() {
        SpanQuery[] spanQueries = new SpanQuery[this.size()];
        Iterator<SpanQuery> sqi = this.weightBySpanQuery.keySet().iterator();
        int i = 0;
        while (sqi.hasNext()) {
            SpanQuery sq2 = sqi.next();
            spanQueries[i++] = sq2;
        }
        if (spanQueries.length == 1) {
            return spanQueries[0];
        }
        return new SpanOrQuery(spanQueries);
    }
}

