/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene94;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.lucene.backward_codecs.lucene94.Lucene94HnswVectorsReader;
import org.apache.lucene.codecs.lucene90.IndexedDISI;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.hnsw.RandomAccessVectorValues;
import org.apache.lucene.util.packed.DirectMonotonicReader;

abstract class OffHeapByteVectorValues
extends ByteVectorValues
implements RandomAccessVectorValues<byte[]> {
    protected final int dimension;
    protected final int size;
    protected final IndexInput slice;
    protected final byte[] binaryValue;
    protected final ByteBuffer byteBuffer;
    protected final int byteSize;

    OffHeapByteVectorValues(int dimension, int size, IndexInput slice, int byteSize) {
        this.dimension = dimension;
        this.size = size;
        this.slice = slice;
        this.byteSize = byteSize;
        this.byteBuffer = ByteBuffer.allocate(byteSize);
        this.binaryValue = this.byteBuffer.array();
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public byte[] vectorValue(int targetOrd) throws IOException {
        this.readValue(targetOrd);
        return this.binaryValue;
    }

    private void readValue(int targetOrd) throws IOException {
        this.slice.seek((long)targetOrd * (long)this.byteSize);
        this.slice.readBytes(this.byteBuffer.array(), this.byteBuffer.arrayOffset(), this.byteSize);
    }

    public abstract int ordToDoc(int var1);

    static OffHeapByteVectorValues load(Lucene94HnswVectorsReader.FieldEntry fieldEntry, IndexInput vectorData) throws IOException {
        if (fieldEntry.docsWithFieldOffset == -2L || fieldEntry.vectorEncoding != VectorEncoding.BYTE) {
            return new EmptyOffHeapVectorValues(fieldEntry.dimension);
        }
        IndexInput bytesSlice = vectorData.slice("vector-data", fieldEntry.vectorDataOffset, fieldEntry.vectorDataLength);
        int byteSize = fieldEntry.dimension;
        if (fieldEntry.docsWithFieldOffset == -1L) {
            return new DenseOffHeapVectorValues(fieldEntry.dimension, fieldEntry.size, bytesSlice, byteSize);
        }
        return new SparseOffHeapVectorValues(fieldEntry, vectorData, bytesSlice, byteSize);
    }

    abstract Bits getAcceptOrds(Bits var1);

    private static class EmptyOffHeapVectorValues
    extends OffHeapByteVectorValues {
        private int doc = -1;

        public EmptyOffHeapVectorValues(int dimension) {
            super(dimension, 0, null, 0);
        }

        @Override
        public int dimension() {
            return super.dimension();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public byte[] vectorValue() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        @Override
        public RandomAccessVectorValues<byte[]> copy() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] vectorValue(int targetOrd) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int ordToDoc(int ord) {
            throw new UnsupportedOperationException();
        }

        @Override
        Bits getAcceptOrds(Bits acceptDocs) {
            return null;
        }
    }

    private static class SparseOffHeapVectorValues
    extends OffHeapByteVectorValues {
        private final DirectMonotonicReader ordToDoc;
        private final IndexedDISI disi;
        private final IndexInput dataIn;
        private final Lucene94HnswVectorsReader.FieldEntry fieldEntry;

        public SparseOffHeapVectorValues(Lucene94HnswVectorsReader.FieldEntry fieldEntry, IndexInput dataIn, IndexInput slice, int byteSize) throws IOException {
            super(fieldEntry.dimension, fieldEntry.size, slice, byteSize);
            this.fieldEntry = fieldEntry;
            RandomAccessInput addressesData = dataIn.randomAccessSlice(fieldEntry.addressesOffset, fieldEntry.addressesLength);
            this.dataIn = dataIn;
            this.ordToDoc = DirectMonotonicReader.getInstance(fieldEntry.meta, addressesData);
            this.disi = new IndexedDISI(dataIn, fieldEntry.docsWithFieldOffset, fieldEntry.docsWithFieldLength, fieldEntry.jumpTableEntryCount, fieldEntry.denseRankPower, fieldEntry.size);
        }

        @Override
        public byte[] vectorValue() throws IOException {
            this.slice.seek((long)this.disi.index() * (long)this.byteSize);
            this.slice.readBytes(this.byteBuffer.array(), this.byteBuffer.arrayOffset(), this.byteSize, false);
            return this.binaryValue;
        }

        @Override
        public int docID() {
            return this.disi.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            return this.disi.nextDoc();
        }

        @Override
        public int advance(int target) throws IOException {
            assert (this.docID() < target);
            return this.disi.advance(target);
        }

        @Override
        public RandomAccessVectorValues<byte[]> copy() throws IOException {
            return new SparseOffHeapVectorValues(this.fieldEntry, this.dataIn, this.slice.clone(), this.byteSize);
        }

        @Override
        public int ordToDoc(int ord) {
            return (int)this.ordToDoc.get(ord);
        }

        @Override
        Bits getAcceptOrds(final Bits acceptDocs) {
            if (acceptDocs == null) {
                return null;
            }
            return new Bits(){

                @Override
                public boolean get(int index) {
                    return acceptDocs.get(this.ordToDoc(index));
                }

                @Override
                public int length() {
                    return size;
                }
            };
        }
    }

    static class DenseOffHeapVectorValues
    extends OffHeapByteVectorValues {
        private int doc = -1;

        public DenseOffHeapVectorValues(int dimension, int size, IndexInput slice, int byteSize) {
            super(dimension, size, slice, byteSize);
        }

        @Override
        public byte[] vectorValue() throws IOException {
            this.slice.seek((long)this.doc * (long)this.byteSize);
            this.slice.readBytes(this.byteBuffer.array(), this.byteBuffer.arrayOffset(), this.byteSize);
            return this.binaryValue;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            assert (this.docID() < target);
            if (target >= this.size) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = target;
            return this.doc;
        }

        @Override
        public RandomAccessVectorValues<byte[]> copy() throws IOException {
            return new DenseOffHeapVectorValues(this.dimension, this.size, this.slice.clone(), this.byteSize);
        }

        @Override
        public int ordToDoc(int ord) {
            return ord;
        }

        @Override
        Bits getAcceptOrds(Bits acceptDocs) {
            return acceptDocs;
        }
    }
}

