/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.LowLevelLogUtil;
import org.apache.logging.log4j.util.PropertiesPropertySource;

public class PropertyFilePropertySource
extends PropertiesPropertySource {
    public PropertyFilePropertySource(String fileName) {
        this(fileName, true);
    }

    public PropertyFilePropertySource(String fileName, boolean useTccl) {
        super(PropertyFilePropertySource.loadPropertiesFile(fileName, useTccl));
    }

    private static Properties loadPropertiesFile(String fileName, boolean useTccl) {
        Properties props = new Properties();
        for (URL url : LoaderUtil.findResources(fileName, useTccl)) {
            try {
                InputStream in = url.openStream();
                try {
                    props.load(in);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (IOException e2) {
                LowLevelLogUtil.logException("Unable to read " + url, e2);
            }
        }
        return props;
    }
}

