/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.convert;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Provider;
import java.security.Security;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.rolling.action.Duration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.convert.Base64Converter;
import org.apache.logging.log4j.core.config.plugins.convert.HexConverter;
import org.apache.logging.log4j.core.config.plugins.convert.TypeConverter;
import org.apache.logging.log4j.core.config.plugins.convert.TypeConverterRegistry;
import org.apache.logging.log4j.core.util.CronExpression;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Constants;
import org.apache.logging.log4j.util.LoaderUtil;
import org.apache.logging.log4j.util.Strings;

public final class TypeConverters {
    public static final String CATEGORY = "TypeConverter";
    private static final Logger LOGGER = StatusLogger.getLogger();

    public static <T> T convert(String s2, Class<? extends T> clazz, Object defaultValue) {
        TypeConverter<?> converter = TypeConverterRegistry.getInstance().findCompatibleConverter(clazz);
        if (s2 == null) {
            return (T)TypeConverters.parseDefaultValue(converter, defaultValue);
        }
        try {
            return (T)converter.convert(s2);
        }
        catch (Exception e2) {
            LOGGER.warn("Error while converting string [{}] to type [{}]. Using default value [{}].", (Object)s2, (Object)clazz, defaultValue, (Object)e2);
            return (T)TypeConverters.parseDefaultValue(converter, defaultValue);
        }
    }

    private static <T> T parseDefaultValue(TypeConverter<T> converter, Object defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        if (!(defaultValue instanceof String)) {
            return (T)defaultValue;
        }
        try {
            return converter.convert((String)defaultValue);
        }
        catch (Exception e2) {
            LOGGER.debug("Can't parse default value [{}] for type [{}].", defaultValue, (Object)converter.getClass(), (Object)e2);
            return null;
        }
    }

    @Plugin(name="UUID", category="TypeConverter")
    public static class UuidConverter
    implements TypeConverter<UUID> {
        @Override
        public UUID convert(String s2) throws Exception {
            return UUID.fromString(s2);
        }
    }

    @Plugin(name="URL", category="TypeConverter")
    public static class UrlConverter
    implements TypeConverter<URL> {
        @Override
        public URL convert(String s2) throws MalformedURLException {
            return new URL(s2);
        }
    }

    @Plugin(name="URI", category="TypeConverter")
    public static class UriConverter
    implements TypeConverter<URI> {
        @Override
        public URI convert(String s2) throws URISyntaxException {
            return new URI(s2);
        }
    }

    @Plugin(name="String", category="TypeConverter")
    public static class StringConverter
    implements TypeConverter<String> {
        @Override
        public String convert(String s2) {
            return s2;
        }
    }

    @Plugin(name="Short", category="TypeConverter")
    public static class ShortConverter
    implements TypeConverter<Short> {
        @Override
        public Short convert(String s2) {
            return Short.valueOf(s2);
        }
    }

    @Plugin(name="SecurityProvider", category="TypeConverter")
    public static class SecurityProviderConverter
    implements TypeConverter<Provider> {
        @Override
        public Provider convert(String s2) {
            return Security.getProvider(s2);
        }
    }

    @Plugin(name="Pattern", category="TypeConverter")
    public static class PatternConverter
    implements TypeConverter<Pattern> {
        @Override
        public Pattern convert(String s2) {
            return Pattern.compile(s2);
        }
    }

    @Plugin(name="Path", category="TypeConverter")
    public static class PathConverter
    implements TypeConverter<Path> {
        @Override
        public Path convert(String s2) throws Exception {
            return Paths.get(s2, new String[0]);
        }
    }

    @Plugin(name="Long", category="TypeConverter")
    public static class LongConverter
    implements TypeConverter<Long> {
        @Override
        public Long convert(String s2) {
            return Long.valueOf(s2);
        }
    }

    @Plugin(name="Level", category="TypeConverter")
    public static class LevelConverter
    implements TypeConverter<Level> {
        @Override
        public Level convert(String s2) {
            return Level.valueOf(s2);
        }
    }

    @Plugin(name="Integer", category="TypeConverter")
    public static class IntegerConverter
    implements TypeConverter<Integer> {
        @Override
        public Integer convert(String s2) {
            return Integer.valueOf(s2);
        }
    }

    @Plugin(name="InetAddress", category="TypeConverter")
    public static class InetAddressConverter
    implements TypeConverter<InetAddress> {
        @Override
        public InetAddress convert(String s2) throws Exception {
            return InetAddress.getByName(s2);
        }
    }

    @Plugin(name="Float", category="TypeConverter")
    public static class FloatConverter
    implements TypeConverter<Float> {
        @Override
        public Float convert(String s2) {
            return Float.valueOf(s2);
        }
    }

    @Plugin(name="File", category="TypeConverter")
    public static class FileConverter
    implements TypeConverter<File> {
        @Override
        public File convert(String s2) {
            return new File(s2);
        }
    }

    @Plugin(name="Duration", category="TypeConverter")
    public static class DurationConverter
    implements TypeConverter<Duration> {
        @Override
        public Duration convert(String s2) {
            return Duration.parse(s2);
        }
    }

    @Plugin(name="Double", category="TypeConverter")
    public static class DoubleConverter
    implements TypeConverter<Double> {
        @Override
        public Double convert(String s2) {
            return Double.valueOf(s2);
        }
    }

    @Plugin(name="CronExpression", category="TypeConverter")
    public static class CronExpressionConverter
    implements TypeConverter<CronExpression> {
        @Override
        public CronExpression convert(String s2) throws Exception {
            return new CronExpression(s2);
        }
    }

    @Plugin(name="Class", category="TypeConverter")
    public static class ClassConverter
    implements TypeConverter<Class<?>> {
        @Override
        public Class<?> convert(String s2) throws ClassNotFoundException {
            switch (Strings.toRootLowerCase(s2)) {
                case "boolean": {
                    return Boolean.TYPE;
                }
                case "byte": {
                    return Byte.TYPE;
                }
                case "char": {
                    return Character.TYPE;
                }
                case "double": {
                    return Double.TYPE;
                }
                case "float": {
                    return Float.TYPE;
                }
                case "int": {
                    return Integer.TYPE;
                }
                case "long": {
                    return Long.TYPE;
                }
                case "short": {
                    return Short.TYPE;
                }
                case "void": {
                    return Void.TYPE;
                }
            }
            return LoaderUtil.loadClass(s2);
        }
    }

    @Plugin(name="Charset", category="TypeConverter")
    public static class CharsetConverter
    implements TypeConverter<Charset> {
        @Override
        public Charset convert(String s2) {
            return Charset.forName(s2);
        }
    }

    @Plugin(name="CharacterArray", category="TypeConverter")
    public static class CharArrayConverter
    implements TypeConverter<char[]> {
        @Override
        public char[] convert(String s2) {
            return s2.toCharArray();
        }
    }

    @Plugin(name="Character", category="TypeConverter")
    public static class CharacterConverter
    implements TypeConverter<Character> {
        @Override
        public Character convert(String s2) {
            if (s2.length() != 1) {
                throw new IllegalArgumentException("Character string must be of length 1: " + s2);
            }
            return Character.valueOf(s2.toCharArray()[0]);
        }
    }

    @Plugin(name="Byte", category="TypeConverter")
    public static class ByteConverter
    implements TypeConverter<Byte> {
        @Override
        public Byte convert(String s2) {
            return Byte.valueOf(s2);
        }
    }

    @Plugin(name="ByteArray", category="TypeConverter")
    public static class ByteArrayConverter
    implements TypeConverter<byte[]> {
        private static final String PREFIX_0x = "0x";
        private static final String PREFIX_BASE64 = "Base64:";

        @Override
        public byte[] convert(String value) {
            byte[] bytes;
            if (value == null || value.isEmpty()) {
                bytes = Constants.EMPTY_BYTE_ARRAY;
            } else if (value.startsWith(PREFIX_BASE64)) {
                String lexicalXSDBase64Binary = value.substring(PREFIX_BASE64.length());
                bytes = Base64Converter.parseBase64Binary(lexicalXSDBase64Binary);
            } else if (value.startsWith(PREFIX_0x)) {
                String lexicalXSDHexBinary = value.substring(PREFIX_0x.length());
                bytes = HexConverter.parseHexBinary(lexicalXSDHexBinary);
            } else {
                bytes = value.getBytes(Charset.defaultCharset());
            }
            return bytes;
        }
    }

    @Plugin(name="Boolean", category="TypeConverter")
    public static class BooleanConverter
    implements TypeConverter<Boolean> {
        @Override
        public Boolean convert(String s2) {
            return Boolean.valueOf(s2);
        }
    }

    @Plugin(name="BigInteger", category="TypeConverter")
    public static class BigIntegerConverter
    implements TypeConverter<BigInteger> {
        @Override
        public BigInteger convert(String s2) {
            return new BigInteger(s2);
        }
    }

    @Plugin(name="BigDecimal", category="TypeConverter")
    public static class BigDecimalConverter
    implements TypeConverter<BigDecimal> {
        @Override
        public BigDecimal convert(String s2) {
            return new BigDecimal(s2);
        }
    }
}

