/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store;

import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.dboe.storage.StorageRDF;
import org.apache.jena.dboe.transaction.txn.Transaction;
import org.apache.jena.dboe.transaction.txn.TransactionException;
import org.apache.jena.dboe.transaction.txn.TransactionalSystem;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.QuadTable;
import org.apache.jena.tdb2.store.TripleTable;

public class StorageTDB
implements StorageRDF {
    private TripleTable tripleTable;
    private QuadTable quadTable;
    private TransactionalSystem txnSystem;
    private final boolean checkForChange = false;
    private boolean closed = false;
    private static final int DeleteBufferSize = 1000;

    public StorageTDB(TransactionalSystem txnSystem, TripleTable tripleTable, QuadTable quadTable) {
        this.txnSystem = txnSystem;
        this.tripleTable = tripleTable;
        this.quadTable = quadTable;
    }

    public QuadTable getQuadTable() {
        this.checkActive();
        return this.quadTable;
    }

    public TripleTable getTripleTable() {
        this.checkActive();
        return this.tripleTable;
    }

    private void checkActive() {
    }

    private final void notifyAdd(Node g2, Node s2, Node p, Node o) {
    }

    private final void notifyDelete(Node g2, Node s2, Node p, Node o) {
    }

    @Override
    public void add(Node s2, Node p, Node o) {
        this.checkActive();
        this.ensureWriteTxn();
        this.notifyAdd(null, s2, p, o);
        this.getTripleTable().add(s2, p, o);
    }

    @Override
    public void add(Node g2, Node s2, Node p, Node o) {
        this.checkActive();
        this.ensureWriteTxn();
        this.notifyAdd(g2, s2, p, o);
        this.getQuadTable().add(g2, s2, p, o);
    }

    @Override
    public void delete(Node s2, Node p, Node o) {
        this.checkActive();
        this.ensureWriteTxn();
        this.notifyDelete(null, s2, p, o);
        this.getTripleTable().delete(s2, p, o);
    }

    @Override
    public void delete(Node g2, Node s2, Node p, Node o) {
        this.checkActive();
        this.ensureWriteTxn();
        this.notifyDelete(g2, s2, p, o);
        this.getQuadTable().delete(g2, s2, p, o);
    }

    @Override
    public void removeAll(Node s2, Node p, Node o) {
        this.checkActive();
        this.ensureWriteTxn();
        this.removeWorker(() -> this.tripleTable.getNodeTupleTable().findAsNodeIds(s2, p, o), x -> this.tripleTable.getNodeTupleTable().getTupleTable().delete((Tuple<NodeId>)x));
    }

    @Override
    public void removeAll(Node g2, Node s2, Node p, Node o) {
        this.checkActive();
        this.ensureWriteTxn();
        this.removeWorker(() -> this.quadTable.getNodeTupleTable().findAsNodeIds(g2, s2, p, o), x -> this.quadTable.getNodeTupleTable().getTupleTable().delete((Tuple<NodeId>)x));
    }

    private void removeWorker(Supplier<Iterator<Tuple<NodeId>>> finder, Consumer<Tuple<NodeId>> deleter) {
        int idx;
        Object[] buffer = new Object[1000];
        do {
            Iterator<Tuple<NodeId>> iter = finder.get();
            for (idx = 0; idx < 1000 && iter.hasNext(); ++idx) {
                buffer[idx] = iter.next();
            }
            for (int i = 0; i < idx; ++i) {
                Tuple x = (Tuple)buffer[i];
                deleter.accept(x);
                buffer[i] = null;
            }
        } while (idx >= 1000);
    }

    @Override
    public Iterator<Quad> find(Node g2, Node s2, Node p, Node o) {
        this.checkActive();
        this.requireTxn();
        return this.getQuadTable().find(g2, s2, p, o);
    }

    @Override
    public Iterator<Triple> find(Node s2, Node p, Node o) {
        this.checkActive();
        this.requireTxn();
        return this.getTripleTable().find(s2, p, o);
    }

    @Override
    public boolean contains(Node s2, Node p, Node o) {
        this.checkActive();
        this.requireTxn();
        return this.getTripleTable().find(s2, p, o).hasNext();
    }

    @Override
    public boolean contains(Node g2, Node s2, Node p, Node o) {
        this.checkActive();
        this.requireTxn();
        return this.getQuadTable().find(g2, s2, p, o).hasNext();
    }

    private void requireTxn() {
    }

    private void ensureWriteTxn() {
        Transaction txn = this.txnSystem.getThreadTransaction();
        if (txn == null) {
            throw new TransactionException("Not on a write transaction");
        }
        txn.ensureWriteTxn();
    }
}

