/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.transaction;

import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.tdb.base.file.FileException;
import org.apache.jena.tdb.base.objectfile.ObjectFile;
import org.apache.jena.tdb.transaction.TDBTransactionException;
import org.apache.jena.tdb.transaction.Transaction;
import org.apache.jena.tdb.transaction.TransactionLifecycle;

public class ObjectFileTransComplex
implements ObjectFile,
TransactionLifecycle {
    private final ObjectFile transObjects;
    private long otherAllocOffset;
    private boolean passthrough = false;
    private boolean inTransaction = false;
    private final ObjectFile base;

    public ObjectFileTransComplex(Transaction txn, ObjectFile base, ObjectFile other) {
        this.base = base;
        this.transObjects = other;
        this.inTransaction = false;
        this.otherAllocOffset = base.length();
    }

    @Override
    public void begin(Transaction txn) {
        this.passthrough = false;
        this.inTransaction = true;
        this.transObjects.reposition(0L);
        this.otherAllocOffset = this.base.length();
    }

    @Override
    public void commitPrepare(Transaction txn) {
        if (!this.inTransaction) {
            throw new TDBTransactionException("Not in a transaction for a commit to happen");
        }
        this.transObjects.sync();
    }

    @Override
    public void committed(Transaction txn) {
    }

    @Override
    public void enactCommitted(Transaction txn) {
        if (!this.inTransaction) {
            throw new TDBTransactionException("Not in a transaction for a commit to happen");
        }
        this.append();
        this.base.sync();
        this.transObjects.reposition(0L);
    }

    @Override
    public void clearupCommitted(Transaction txn) {
        this.transObjects.truncate(0L);
        this.passthrough = true;
    }

    @Override
    public void abort(Transaction txn) {
        this.transObjects.reposition(0L);
    }

    private void append() {
        this.base.reposition(this.otherAllocOffset);
        Iterator<Pair<Long, ByteBuffer>> iter = this.transObjects.all();
        while (iter.hasNext()) {
            Pair<Long, ByteBuffer> p = iter.next();
            String s2 = StrUtils.fromUTF8bytes(p.getRight().array());
            long x = this.base.write(p.getRight());
            if (p.getLeft() + this.otherAllocOffset == x) continue;
            throw new FileException("Expected id of " + (p.getLeft() + this.otherAllocOffset) + ", got an id of " + x);
        }
    }

    @Override
    public void reposition(long id) {
        if (this.passthrough) {
            this.base.reposition(id);
            return;
        }
        if (id > this.otherAllocOffset) {
            this.transObjects.reposition(this.mapToOther(id));
            return;
        }
        Log.warn(this, "Unexpected: Attempt to reposition over base file");
        this.base.reposition(id);
        this.transObjects.reposition(0L);
        this.otherAllocOffset = this.base.length();
    }

    @Override
    public void truncate(long id) {
        if (this.passthrough) {
            this.base.truncate(id);
            return;
        }
        if (id > this.otherAllocOffset) {
            this.transObjects.truncate(this.mapToOther(id));
            return;
        }
        this.base.truncate(id);
        this.transObjects.truncate(0L);
        this.otherAllocOffset = this.base.length();
    }

    private long mapToOther(long x) {
        return x - this.otherAllocOffset;
    }

    private long mapFromOther(long x) {
        return x + this.otherAllocOffset;
    }

    @Override
    public long write(ByteBuffer buffer) {
        if (this.passthrough) {
            return this.base.write(buffer);
        }
        long x = this.transObjects.write(buffer);
        return this.mapFromOther(x);
    }

    @Override
    public ByteBuffer read(long id) {
        if (this.passthrough) {
            return this.base.read(id);
        }
        if (id < this.otherAllocOffset) {
            return this.base.read(id);
        }
        long x = this.mapToOther(id);
        return this.transObjects.read(id - this.otherAllocOffset);
    }

    @Override
    public long length() {
        if (this.passthrough) {
            return this.base.length();
        }
        return this.otherAllocOffset + this.transObjects.length();
    }

    @Override
    public boolean isEmpty() {
        if (this.passthrough) {
            return this.base.isEmpty();
        }
        return this.transObjects.isEmpty() && this.base.isEmpty();
    }

    @Override
    public Iterator<Pair<Long, ByteBuffer>> all() {
        if (this.passthrough) {
            return this.base.all();
        }
        return Iter.concat(this.base.all(), this.transObjects.all());
    }

    @Override
    public void sync() {
        if (this.passthrough) {
            this.base.sync();
            return;
        }
    }

    @Override
    public void close() {
        if (this.passthrough) {
            this.base.close();
            return;
        }
    }

    @Override
    public String getLabel() {
        return "(" + this.base.getLabel() + ":" + this.transObjects.getLabel() + ")";
    }
}

