/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.solver.stats;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.tdb.solver.stats.StatsResults;

abstract class StatsCollectorBase<T> {
    private long count = 0L;
    private Map<T, Long> predicates = new HashMap<T, Long>(10000);
    private Map<T, Long> types = new HashMap<T, Long>(10000);
    private T typeTrigger;

    protected StatsCollectorBase(T typeTrigger) {
        this.typeTrigger = typeTrigger;
    }

    public void record(T g2, T s2, T p, T o) {
        ++this.count;
        this.predicates.put(p, this.predicates.getOrDefault(p, 0L) + 1L);
        if (this.typeTrigger != null && this.typeTrigger.equals(p)) {
            this.types.put(o, this.types.getOrDefault(o, 0L) + 1L);
        }
    }

    protected abstract Map<Node, Long> convert(Map<T, Long> var1);

    public StatsResults results() {
        return new StatsResults(this.convert(this.predicates), this.convert(this.types), this.count);
    }
}

