/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.graph.Node;

public class NodeToLabelMap {
    int bNodeCounter = 0;
    Map<Node, String> bNodeStrings = new HashMap<Node, String>();
    boolean bNodesAsFakeURIs = false;
    String prefixString = "b";

    public NodeToLabelMap() {
        this("b");
    }

    public NodeToLabelMap(String prefix) {
        this(prefix, false);
    }

    public NodeToLabelMap(String prefix, boolean bNodesAsFakeURIs) {
        if (prefix == null || prefix.equals("")) {
            throw new IllegalArgumentException("Must provide a prefix");
        }
        this.prefixString = "_:" + prefix;
        this.bNodesAsFakeURIs = bNodesAsFakeURIs;
    }

    public String asString(Node n) {
        if (!n.isBlank()) {
            return null;
        }
        return this.mapNode(n);
    }

    protected synchronized String mapNode(Node n) {
        String s2 = this.bNodeStrings.get(n);
        if (s2 != null) {
            return s2;
        }
        s2 = this.genStringForNode(n);
        this.bNodeStrings.put(n, s2);
        return s2;
    }

    protected String genStringForNode(Node n) {
        if (this.bNodesAsFakeURIs && n.isBlank()) {
            return "<_:" + n.getBlankNodeId().getLabelString() + ">";
        }
        return this.prefixString + this.bNodeCounter++;
    }
}

