/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.table.TableData;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.QuadPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformExpr;
import org.apache.jena.sparql.graph.NodeTransformOp;

public class NodeTransformLib {
    public static Op transform(NodeTransform nodeTransform, Op op) {
        NodeTransformOp opTransform = new NodeTransformOp(nodeTransform);
        NodeTransformExpr exprTransform = new NodeTransformExpr(nodeTransform);
        return Transformer.transform(opTransform, exprTransform, op);
    }

    public static BasicPattern transform(NodeTransform nodeTransform, BasicPattern pattern) {
        BasicPattern bgp2 = new BasicPattern();
        boolean changed = false;
        for (Triple triple : pattern) {
            Triple t2 = NodeTransformLib.transform(nodeTransform, triple);
            bgp2.add(t2);
            if (t2 == triple) continue;
            changed = true;
        }
        if (!changed) {
            return pattern;
        }
        return bgp2;
    }

    public static QuadPattern transform(NodeTransform nodeTransform, QuadPattern pattern) {
        QuadPattern qp2 = new QuadPattern();
        boolean changed = false;
        for (Quad quad : pattern) {
            Quad q2 = NodeTransformLib.transform(nodeTransform, quad);
            qp2.add(q2);
            if (q2 == quad) continue;
            changed = true;
        }
        if (!changed) {
            return pattern;
        }
        return qp2;
    }

    public static Triple transform(NodeTransform nodeTransform, Triple triple) {
        Node o1;
        Node p1;
        boolean change = false;
        Node s2 = triple.getSubject();
        Node p = triple.getPredicate();
        Node o = triple.getObject();
        Node s1 = (Node)nodeTransform.apply(s2);
        if (s1 != s2) {
            change = true;
            s2 = s1;
        }
        if ((p1 = (Node)nodeTransform.apply(p)) != p) {
            change = true;
            p = p1;
        }
        if ((o1 = (Node)nodeTransform.apply(o)) != o) {
            change = true;
            o = o1;
        }
        if (!change) {
            return triple;
        }
        return Triple.create(s2, p, o);
    }

    public static Quad transform(NodeTransform nodeTransform, Quad quad) {
        Node o1;
        Node p1;
        Node s1;
        boolean change = false;
        Node s2 = quad.getSubject();
        Node p = quad.getPredicate();
        Node o = quad.getObject();
        Node g2 = quad.getGraph();
        Node g1 = (Node)nodeTransform.apply(g2);
        if (g1 != g2) {
            change = true;
            g2 = g1;
        }
        if ((s1 = (Node)nodeTransform.apply(s2)) != s2) {
            change = true;
            s2 = s1;
        }
        if ((p1 = (Node)nodeTransform.apply(p)) != p) {
            change = true;
            p = p1;
        }
        if ((o1 = (Node)nodeTransform.apply(o)) != o) {
            change = true;
            o = o1;
        }
        if (!change) {
            return quad;
        }
        return new Quad(g2, s2, p, o);
    }

    public static Table transform(Table table, NodeTransform transform) {
        List<Var> vars = NodeTransformLib.transformVars(transform, table.getVars());
        Iterator<Binding> iter = table.rows();
        ArrayList<Binding> newRows = new ArrayList<Binding>();
        while (iter.hasNext()) {
            Binding b = iter.next();
            Binding b2 = NodeTransformLib.transform(b, transform);
            newRows.add(b2);
        }
        return new TableData(vars, newRows);
    }

    public static Binding transform(Binding b, NodeTransform transform) {
        BindingBuilder b2 = Binding.builder();
        List<Var> vars = Iter.toList(b.vars());
        for (Var v : vars) {
            Var v2 = (Var)transform.apply(v);
            b2.add(v2, b.get(v));
        }
        return b2.build();
    }

    public static List<Quad> transformQuads(NodeTransform nodeTransform, List<Quad> quads) {
        ArrayList<Quad> x = new ArrayList<Quad>();
        boolean changed = false;
        for (Quad q : quads) {
            Quad q2;
            if (q != (q2 = NodeTransformLib.transform(nodeTransform, q))) {
                changed = true;
            }
            x.add(q2);
        }
        if (!changed) {
            return quads;
        }
        return x;
    }

    public static VarExprList transformVars(NodeTransform transform, VarExprList varExprList) {
        VarExprList varExprList2 = new VarExprList();
        boolean changed = false;
        for (Var v : varExprList.getVars()) {
            Expr expr = varExprList.getExpr(v);
            Var v2 = (Var)transform.apply(v);
            if (!Objects.equals(v, v2)) {
                changed = true;
            }
            varExprList2.add(v2, expr);
        }
        if (!changed) {
            return varExprList;
        }
        return varExprList2;
    }

    public static List<Var> transformVars(NodeTransform nodeTransform, List<Var> varList) {
        ArrayList<Var> varList2 = new ArrayList<Var>(varList.size());
        boolean changed = false;
        for (Var v : varList) {
            Var v2 = (Var)nodeTransform.apply(v);
            varList2.add(v2);
            if (Objects.equals(v, v2)) continue;
            changed = true;
        }
        if (!changed) {
            return varList;
        }
        return varList2;
    }

    public static ExprList transform(NodeTransform nodeTransform, ExprList exprList) {
        ExprList exprList2 = new ExprList();
        boolean changed = false;
        for (Expr expr : exprList) {
            Expr expr2;
            if (expr != (expr2 = NodeTransformLib.transform(nodeTransform, expr))) {
                changed = true;
            }
            exprList2.add(expr2);
        }
        if (!changed) {
            return exprList;
        }
        return exprList2;
    }

    public static Expr transform(NodeTransform nodeTransform, Expr expr) {
        return expr.applyNodeTransform(nodeTransform);
    }
}

