/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprVisitor;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.graph.NodeTransform;

public abstract class ExprFunction1
extends ExprFunction {
    protected final Expr expr;

    protected ExprFunction1(Expr expr, String fName) {
        this(expr, fName, null);
    }

    protected ExprFunction1(Expr expr, String fName, String opSign) {
        super(fName, opSign);
        this.expr = expr;
    }

    public Expr getArg() {
        return this.expr;
    }

    @Override
    public Expr getArg(int i) {
        if (i == 1) {
            return this.expr;
        }
        return null;
    }

    @Override
    public int hashCode() {
        return this.getFunctionSymbol().hashCode() ^ Lib.hashCodeObject(this.expr);
    }

    @Override
    public int numArgs() {
        return 1;
    }

    @Override
    public final NodeValue eval(Binding binding, FunctionEnv env) {
        NodeValue s2 = this.evalSpecial(binding, env);
        if (s2 != null) {
            return s2;
        }
        NodeValue x = ExprFunction1.eval(binding, env, this.expr);
        return this.eval(x, env);
    }

    public NodeValue eval(NodeValue v, FunctionEnv env) {
        return this.eval(v);
    }

    public abstract NodeValue eval(NodeValue var1);

    protected NodeValue evalSpecial(Binding binding, FunctionEnv env) {
        return null;
    }

    @Override
    public final Expr copySubstitute(Binding binding) {
        Expr e2 = this.expr == null ? null : this.expr.copySubstitute(binding);
        return this.copy(e2);
    }

    @Override
    public final Expr applyNodeTransform(NodeTransform transform) {
        Expr e2 = this.expr == null ? null : this.expr.applyNodeTransform(transform);
        return this.copy(e2);
    }

    public abstract Expr copy(Expr var1);

    @Override
    public void visit(ExprVisitor visitor) {
        visitor.visit(this);
    }

    public Expr apply(ExprTransform transform, Expr sub) {
        return transform.transform(this, sub);
    }
}

