/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.op;

import java.util.List;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.op.Op1;
import org.apache.jena.sparql.algebra.op.OpModifier;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class OpTopN
extends OpModifier {
    private final List<SortCondition> conditions;
    private final int limit;

    public OpTopN(Op subOp, int N2, List<SortCondition> conditions) {
        super(subOp);
        this.conditions = conditions;
        this.limit = N2;
    }

    public List<SortCondition> getConditions() {
        return this.conditions;
    }

    public int getLimit() {
        return this.limit;
    }

    @Override
    public String getName() {
        return "top";
    }

    @Override
    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    @Override
    public Op1 copy(Op subOp) {
        return new OpTopN(subOp, this.limit, this.conditions);
    }

    @Override
    public Op apply(Transform transform, Op subOp) {
        return transform.transform(this, subOp);
    }

    @Override
    public int hashCode() {
        return this.conditions.hashCode() ^ this.getSubOp().hashCode();
    }

    @Override
    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpTopN)) {
            return false;
        }
        OpTopN opTopN = (OpTopN)other;
        return this.getSubOp().equalTo(opTopN.getSubOp(), labelMap);
    }
}

