/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.sys;

import java.io.OutputStream;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.shex.ShexRecord;
import org.apache.jena.shex.ShexReport;
import org.apache.jena.shex.ShexStatus;
import org.apache.jena.shex.expressions.NodeConstraintVisitor;
import org.apache.jena.shex.expressions.ShapeExprVisitor;
import org.apache.jena.shex.expressions.ShapeExprWalker;
import org.apache.jena.shex.expressions.ShapeExpression;
import org.apache.jena.shex.expressions.TripleConstraint;
import org.apache.jena.shex.expressions.TripleExprVisitor;
import org.apache.jena.shex.sys.SysShex;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.XSD;

public class ShexLib {
    private static PrefixMap displayPrefixMap = PrefixMapFactory.createForOutput();
    private static NodeFormatter nodeFmtAbbrev = new NodeFormatterTTL(null, displayPrefixMap);

    public static String fragment(String uri) {
        int idx = uri.indexOf(35);
        if (idx < 0) {
            return "";
        }
        return uri.substring(idx);
    }

    public static void walk(ShapeExpression shExpr, final ShapeExprVisitor shapeVisitor, TripleExprVisitor tripleExpressionVisitor, NodeConstraintVisitor nodeConstraintVisitor) {
        TripleExprVisitor tExprVisitor = new TripleExprVisitor(){

            @Override
            public void visit(TripleConstraint object) {
                ShapeExpression theShapeExpression = object.getShapeExpression();
                if (theShapeExpression != null) {
                    theShapeExpression.visit(shapeVisitor);
                }
            }
        };
        ShapeExprWalker walker = new ShapeExprWalker(shapeVisitor, null, tripleExpressionVisitor, null, nodeConstraintVisitor);
        shExpr.visit(walker);
    }

    public static String strDatatype(Node n) {
        if (n.isLiteral() && n.getLiteralDatatypeURI().startsWith(XSD.getURI())) {
            int x = XSD.getURI().length();
            String s2 = n.getLiteralDatatypeURI().substring(x);
            return "xsd:" + s2;
        }
        String s3 = "<" + n.getLiteralDatatypeURI() + ">";
        return s3;
    }

    public static String displayStr(Node n) {
        if (n == null) {
            return "<null>";
        }
        if (n == SysShex.focusNode) {
            return "FOCUS";
        }
        if (n == SysShex.startNode) {
            return "START";
        }
        return ShexLib.displayStr(n, nodeFmtAbbrev);
    }

    private static String displayStr(Node n, NodeFormatter nodeFmt) {
        IndentedLineBuffer sw = new IndentedLineBuffer();
        nodeFmt.format(sw, n);
        return sw.toString();
    }

    public static String displayStr(Triple triple) {
        return ShexLib.displayStr(triple.getSubject()) + " " + ShexLib.displayStr(triple.getPredicate()) + " " + ShexLib.displayStr(triple.getObject());
    }

    public static void printReport(ShexReport report) {
        ShexLib.printReport(System.out, report);
    }

    public static void printReport(OutputStream outStream, ShexReport report) {
        AWriter out = IO.wrapUTF8(outStream);
        try {
            if (!report.hasReports()) {
                out.println("OK");
            } else {
                report.forEachReport(reportEntry -> ShexLib.printReport(out, reportEntry));
            }
        }
        finally {
            out.flush();
        }
    }

    private static void printReport(AWriter out, ShexRecord reportEntry) {
        String target = reportEntry.strTarget();
        ShexStatus status = reportEntry.status;
        String reason = reportEntry.reason;
        Node focusNode = reportEntry.focus;
        switch (status) {
            case conformant: {
                out.printf("%s :: Focus = %s, Status = %s\n", target, ShexLib.displayStr(focusNode), status.toString());
                break;
            }
            case nonconformant: {
                out.printf("%s :: Focus = %s, Status = %s, Reason = %s\n", target, ShexLib.displayStr(focusNode), status.toString(), reason == null ? "--" : reason);
            }
        }
    }

    static {
        displayPrefixMap.add("owl", OWL.getURI());
        displayPrefixMap.add("rdf", RDF.getURI());
        displayPrefixMap.add("rdfs", RDFS.getURI());
        displayPrefixMap.add("xsd", XSD.getURI());
    }
}

