/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.other.G;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shacl.ShaclException;
import org.apache.jena.shacl.ValidationReport;
import org.apache.jena.shacl.compact.writer.CompactOut;
import org.apache.jena.shacl.compact.writer.CompactWriter;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.ReportConstraint;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.ConstraintVisitor;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.shacl.validation.ValidationProc;
import org.apache.jena.shacl.validation.event.ConstraintEvaluatedOnPathNodesWithCompareNodesEvent;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.sparql.path.Path;

public class QualifiedValueShape
implements Constraint {
    private final Shape sub;
    private int qMin;
    private int qMax;
    private boolean qDisjoint;

    public QualifiedValueShape(Shape sub, int qMin, int qMax, boolean qDisjoint) {
        this.sub = sub;
        this.qMin = qMin;
        this.qMax = qMax;
        this.qDisjoint = qDisjoint;
    }

    public Shape getSub() {
        return this.sub;
    }

    public int qMin() {
        return this.qMin;
    }

    public int qMax() {
        return this.qMax;
    }

    public boolean qDisjoint() {
        return this.qDisjoint;
    }

    @Override
    public void validateNodeShape(ValidationContext vCxt, Graph data, Shape shape, Node focusNode) {
        throw new ShaclException("sh:qualifiedValueShape only valid in a property shape");
    }

    @Override
    public void validatePropertyShape(ValidationContext vCxt, Graph data, Shape shape, Node focusNode, Path path, Set<Node> valueNodes) {
        boolean bl;
        boolean bl2;
        Set<Node> valueNodes2;
        Collection<Node> sibs = this.siblings(vCxt.getShapesGraph(), shape);
        if (this.qDisjoint) {
            valueNodes2 = new HashSet<Node>();
            for (Node node : valueNodes) {
                if (this.conformsSiblings(vCxt, node, sibs)) continue;
                valueNodes2.add(node);
            }
        } else {
            valueNodes2 = valueNodes;
        }
        int x = 0;
        for (Node v : valueNodes2) {
            boolean b = QualifiedValueShape.conforms(vCxt, this.sub, v);
            if (!b) continue;
            ++x;
        }
        boolean bl3 = true;
        if (this.qMin >= 0 && this.qMin > x) {
            bl2 = false;
            String msg = this.toString() + ": Min = " + this.qMin + " but got " + x + " validations";
            vCxt.reportEntry(msg, shape, focusNode, path, null, new ReportConstraint(SHACL.QualifiedMinCountConstraintComponent));
        }
        int finalX = x;
        void finalPassed = bl2;
        if (this.qMin > 0) {
            vCxt.notifyValidationListener(() -> this.lambda$validatePropertyShape$0(vCxt, shape, focusNode, path, valueNodes, valueNodes2, finalX, (boolean)finalPassed));
        }
        boolean bl4 = true;
        if (this.qMax >= 0 && this.qMax < x) {
            bl = false;
            String msg = this.toString() + ": Max = " + this.qMax + " but got " + x + " validations";
            vCxt.reportEntry(msg, shape, focusNode, path, null, new ReportConstraint(SHACL.QualifiedMaxCountConstraintComponent));
        }
        if (this.qMax > 0) {
            void finalPassed2 = bl;
            vCxt.notifyValidationListener(() -> this.lambda$validatePropertyShape$1(vCxt, shape, focusNode, path, valueNodes, valueNodes2, finalX, (boolean)finalPassed2));
        }
    }

    private boolean conformsSiblings(ValidationContext vCxt, Node v, Collection<Node> sibs) {
        for (Node sib : sibs) {
            Shape sibShape = vCxt.getShapes().getShape(sib);
            boolean b = QualifiedValueShape.conforms(vCxt, sibShape, v);
            if (!b) continue;
            return true;
        }
        return false;
    }

    private static boolean conforms(ValidationContext vCxt, Shape shape, Node v) {
        ValidationContext vCxt2 = ValidationContext.create(vCxt);
        ValidationProc.execValidateShape(vCxt2, vCxt.getDataGraph(), shape, v);
        ValidationReport report = vCxt2.generateReport();
        return report.conforms();
    }

    private Collection<Node> siblings(Graph shapesGraph, Shape thisShape) {
        if (!this.qDisjoint) {
            return Collections.emptySet();
        }
        Node thisShapeNode = thisShape.getShapeNode();
        HashSet sibs = new HashSet();
        List<Node> parents = G.listPO(shapesGraph, SHACL.property, thisShapeNode);
        parents.forEach(s2 -> {
            List<Node> sibs1 = G.listSP(shapesGraph, s2, SHACL.property);
            sibs.addAll(sibs1);
        });
        HashSet<Node> sibShapes = new HashSet<Node>();
        sibs.forEach(s2 -> {
            List<Node> x = G.listSP(shapesGraph, s2, SHACL.qualifiedValueShape);
            sibShapes.addAll(x);
        });
        sibShapes.remove(this.sub.getShapeNode());
        return sibShapes;
    }

    @Override
    public Node getComponent() {
        return SHACL.qualifiedValueShape;
    }

    @Override
    public void visit(ConstraintVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void printCompact(IndentedWriter out, NodeFormatter nodeFmt) {
        boolean outputDone = false;
        if (this.qMin >= 0) {
            CompactOut.compact(out, "qualifiedMinCount", this.qMin);
            outputDone = true;
        }
        if (this.qMax >= 0) {
            if (outputDone) {
                out.print(" ");
            }
            CompactOut.compact(out, "qualifiedMaxCount", this.qMax);
            outputDone = true;
        }
        if (this.qDisjoint) {
            if (outputDone) {
                out.print(" ");
            }
            CompactOut.compactUnquotedString(out, "qualifiedValueShapesDisjoint", "true");
            outputDone = true;
        }
        if (outputDone) {
            out.print(" ");
        }
        CompactWriter.output(out, nodeFmt, this.sub);
    }

    public String toString() {
        return String.format("QualifiedValueShape[%s,%s,%s]", this.qMin < 0 ? "_" : Integer.toString(this.qMin), this.qMax < 0 ? "_" : Integer.toString(this.qMax), this.qDisjoint);
    }

    public static class QualifiedMaxCountConstraintEvaluatedEvent
    extends ConstraintEvaluatedOnPathNodesWithCompareNodesEvent {
        final int maxCount;
        final int actualCount;

        public QualifiedMaxCountConstraintEvaluatedEvent(ValidationContext vCxt, Shape shape, Node focusNode, Constraint constraint, Path path, Set<Node> valueNodes, Set<Node> compareNodes, int maxCount, int actualCount, boolean valid) {
            super(vCxt, shape, focusNode, constraint, path, valueNodes, compareNodes, valid);
            this.maxCount = maxCount;
            this.actualCount = actualCount;
        }

        public int getMaxCount() {
            return this.maxCount;
        }

        public int getActualCount() {
            return this.actualCount;
        }
    }

    public static class QualifiedMinCountConstraintEvaluatedEvent
    extends ConstraintEvaluatedOnPathNodesWithCompareNodesEvent {
        final int minCount;
        final int actualCount;

        public QualifiedMinCountConstraintEvaluatedEvent(ValidationContext vCxt, Shape shape, Node focusNode, Constraint constraint, Path path, Set<Node> valueNodes, Set<Node> compareNodes, int minCount, int actualCount, boolean valid) {
            super(vCxt, shape, focusNode, constraint, path, valueNodes, compareNodes, valid);
            this.minCount = minCount;
            this.actualCount = actualCount;
        }

        public int getMinCount() {
            return this.minCount;
        }

        public int getActualCount() {
            return this.actualCount;
        }
    }
}

