/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import org.apache.jena.graph.Node;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.lang.LangNTuple;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.TokenType;
import org.apache.jena.riot.tokens.Tokenizer;
import org.apache.jena.sparql.core.Quad;

public class LangNQuads
extends LangNTuple<Quad> {
    private Node currentGraph = null;

    public LangNQuads(Tokenizer tokens2, ParserProfile profile, StreamRDF dest) {
        super(tokens2, profile, dest);
    }

    @Override
    public Lang getLang() {
        return RDFLanguages.NQUADS;
    }

    @Override
    protected final void runParser() {
        while (this.hasNext()) {
            Quad x = this.parseOne();
            if (x == null) continue;
            this.dest.quad(x);
        }
    }

    @Override
    protected final Quad parseOne() {
        Node o;
        Node s2;
        Token sToken = this.nextToken();
        if (sToken.isEOF()) {
            this.exception(sToken, "Premature end of file: %s", sToken);
        }
        if (sToken.hasType(TokenType.LT2)) {
            s2 = this.parseTripleTerm();
        } else {
            this.checkIRIOrBNode(sToken);
            s2 = this.tokenAsNode(sToken);
        }
        Token pToken = this.nextToken();
        if (pToken.isEOF()) {
            this.exception(pToken, "Premature end of file: %s", pToken);
        }
        this.checkIRI(pToken);
        Node p = this.tokenAsNode(pToken);
        Token oToken = this.nextToken();
        if (oToken.isEOF()) {
            this.exception(oToken, "Premature end of file: %s", oToken);
        }
        if (oToken.hasType(TokenType.LT2)) {
            o = this.parseTripleTerm();
        } else {
            this.checkRDFTerm(oToken);
            o = this.tokenAsNode(oToken);
        }
        Token xToken = this.nextToken();
        if (xToken.getType() == TokenType.EOF) {
            this.exception(xToken, "Premature end of file: Quad not terminated by DOT: %s", xToken);
        }
        Node c = null;
        if (xToken.getType() != TokenType.DOT) {
            this.checkIRIOrBNode(xToken);
            c = this.tokenAsNode(xToken);
            xToken = this.nextToken();
            this.currentGraph = c;
        } else {
            c = Quad.defaultGraphNodeGenerated;
            this.currentGraph = null;
        }
        if (xToken.getType() != TokenType.DOT) {
            this.exception(xToken, "Quad not terminated by DOT: %s", xToken);
        }
        return this.profile.createQuad(c, s2, p, o, sToken.getLine(), sToken.getColumn());
    }

    @Override
    protected final Node tokenAsNode(Token token) {
        return this.profile.create(this.currentGraph, token);
    }
}

