/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.impl;

import java.util.HashSet;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.reasoner.Finder;
import org.apache.jena.reasoner.TriplePattern;
import org.apache.jena.reasoner.rulesys.FBRuleInfGraph;
import org.apache.jena.reasoner.rulesys.RulePreprocessHook;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class RDFSCMPPreprocessHook
implements RulePreprocessHook {
    protected static String memberPrefix = RDF.getURI() + "_";

    @Override
    public void run(FBRuleInfGraph infGraph, Finder dataFind, Graph inserts) {
        ExtendedIterator<Triple> it = dataFind.find(new TriplePattern(null, null, null));
        HashSet<Node> properties = new HashSet<Node>();
        while (it.hasNext()) {
            Triple triple = (Triple)it.next();
            Node prop = triple.getPredicate();
            if (prop.equals(RDF.Nodes.type) && triple.getObject().equals(RDF.Nodes.Property)) {
                prop = triple.getSubject();
            }
            if (!properties.add(prop) || !prop.getURI().startsWith(memberPrefix)) continue;
            inserts.add(Triple.create(prop, RDF.Nodes.type, RDFS.Nodes.ContainerMembershipProperty));
        }
    }

    @Override
    public boolean needsRerun(FBRuleInfGraph infGraph, Triple t2) {
        return t2.getPredicate().getURI().startsWith(memberPrefix);
    }
}

