/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.reasoner.Finder;
import org.apache.jena.reasoner.ReasonerException;
import org.apache.jena.reasoner.TriplePattern;
import org.apache.jena.reasoner.rulesys.ClauseEntry;
import org.apache.jena.reasoner.rulesys.FBRuleInfGraph;
import org.apache.jena.reasoner.rulesys.Node_RuleVariable;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.reasoner.rulesys.RulePreprocessHook;
import org.apache.jena.reasoner.rulesys.Util;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class OWLRuleTranslationHook
implements RulePreprocessHook {
    @Override
    public void run(FBRuleInfGraph infGraph, Finder dataFind, Graph inserts) {
        ExtendedIterator<Triple> it = dataFind.find(new TriplePattern(null, OWL.intersectionOf.asNode(), null));
        while (it.hasNext()) {
            Triple decl = (Triple)it.next();
            Node className = decl.getSubject();
            ArrayList<Node> elements = new ArrayList<Node>();
            OWLRuleTranslationHook.translateIntersectionList(decl.getObject(), dataFind, elements);
            ArrayList<ClauseEntry> recognitionBody = new ArrayList<ClauseEntry>();
            Node_RuleVariable var = new Node_RuleVariable("?x", 0);
            for (Node description : elements) {
                Rule ir = new Rule("intersectionImplication", new ClauseEntry[]{new TriplePattern(className, RDFS.subClassOf.asNode(), description)}, new ClauseEntry[0]);
                ir.setBackward(false);
                infGraph.addRuleDuringPrepare(ir);
                recognitionBody.add(new TriplePattern(var, RDF.type.asNode(), description));
            }
            ArrayList<ClauseEntry> recognitionHead = new ArrayList<ClauseEntry>(1);
            recognitionHead.add(new TriplePattern(var, RDF.type.asNode(), className));
            Rule rr = new Rule("intersectionRecognition", recognitionHead, recognitionBody);
            rr.setBackward(true);
            infGraph.addRuleDuringPrepare(rr);
        }
    }

    protected static void translateIntersectionList(Node node, Finder dataFind, List<Node> elements) {
        if (node == null) {
            throw new ReasonerException("Illegal list structure in owl:intersectionOf");
        }
        if (node.equals(RDF.nil.asNode())) {
            return;
        }
        Node description = Util.getPropValue(node, RDF.first.asNode(), dataFind);
        if (description == null) {
            throw new ReasonerException("Illegal list structure in owl:intersectionOf");
        }
        elements.add(description);
        Node next = Util.getPropValue(node, RDF.rest.asNode(), dataFind);
        OWLRuleTranslationHook.translateIntersectionList(next, dataFind, elements);
    }

    @Override
    public boolean needsRerun(FBRuleInfGraph infGraph, Triple t2) {
        return t2.getPredicate().equals(OWL.intersectionOf.asNode());
    }
}

