/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.changes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.graph.Node;
import org.apache.jena.rdfpatch.PatchHeader;
import org.apache.jena.rdfpatch.RDFChanges;
import org.apache.jena.rdfpatch.RDFPatch;
import org.apache.jena.rdfpatch.items.AddPrefix;
import org.apache.jena.rdfpatch.items.AddQuad;
import org.apache.jena.rdfpatch.items.ChangeItem;
import org.apache.jena.rdfpatch.items.DeletePrefix;
import org.apache.jena.rdfpatch.items.DeleteQuad;
import org.apache.jena.rdfpatch.items.HeaderItem;
import org.apache.jena.rdfpatch.items.Segment;
import org.apache.jena.rdfpatch.items.TxnAbort;
import org.apache.jena.rdfpatch.items.TxnBegin;
import org.apache.jena.rdfpatch.items.TxnCommit;

public class RDFChangesCollector
implements RDFChanges {
    private static final boolean RECORD_HEADER = false;
    private Map<String, Node> header = new LinkedHashMap<String, Node>();
    private List<ChangeItem> actions = new LinkedList<ChangeItem>();

    public RDFPatch getRDFPatch() {
        return new RDFPatchStored(new HashMap<String, Node>(this.header), new ArrayList<ChangeItem>(this.actions));
    }

    private void enactFlip(ChangeItem a, RDFChanges target) {
        if (a instanceof AddQuad) {
            AddQuad a2 = (AddQuad)a;
            target.delete(a2.g, a2.s, a2.p, a2.o);
            return;
        }
        if (a instanceof DeleteQuad) {
            DeleteQuad a2 = (DeleteQuad)a;
            target.add(a2.g, a2.s, a2.p, a2.o);
            return;
        }
        RDFChangesCollector.enact(a, target);
    }

    private static void enact(ChangeItem item, RDFChanges target) {
        if (item instanceof HeaderItem) {
            HeaderItem h2 = (HeaderItem)item;
            target.header(h2.field, h2.value);
            return;
        }
        if (item instanceof AddQuad) {
            AddQuad a2 = (AddQuad)item;
            target.add(a2.g, a2.s, a2.p, a2.o);
            return;
        }
        if (item instanceof DeleteQuad) {
            DeleteQuad a2 = (DeleteQuad)item;
            target.delete(a2.g, a2.s, a2.p, a2.o);
            return;
        }
        if (item instanceof AddPrefix) {
            AddPrefix a2 = (AddPrefix)item;
            target.addPrefix(a2.gn, a2.prefix, a2.uriStr);
            return;
        }
        if (item instanceof DeletePrefix) {
            DeletePrefix a2 = (DeletePrefix)item;
            target.deletePrefix(a2.gn, a2.prefix);
            return;
        }
        if (item instanceof TxnBegin) {
            target.txnBegin();
            return;
        }
        if (item instanceof TxnCommit) {
            target.txnCommit();
            return;
        }
        if (item instanceof TxnAbort) {
            target.txnAbort();
            return;
        }
        if (item instanceof Segment) {
            target.segment();
            return;
        }
        FmtLog.warn(RDFChangesCollector.class, "Unrecognized action: %s : %s", Lib.className(item), item);
    }

    private void collect(ChangeItem object) {
        this.actions.add(object);
    }

    @Override
    public void start() {
        this.internalReset();
    }

    @Override
    public void finish() {
    }

    @Override
    public void segment() {
        this.actions.add(new Segment());
    }

    public void reset() {
        this.internalReset();
    }

    private void internalReset() {
        this.header.clear();
        this.actions.clear();
    }

    @Override
    public void header(String field, Node value) {
        this.header.put(field, value);
    }

    protected Node header(String field) {
        return this.header.get(field);
    }

    @Override
    public void add(Node g2, Node s2, Node p, Node o) {
        this.collect(new AddQuad(g2, s2, p, o));
    }

    @Override
    public void delete(Node g2, Node s2, Node p, Node o) {
        this.collect(new DeleteQuad(g2, s2, p, o));
    }

    @Override
    public void addPrefix(Node gn, String prefix, String uriStr) {
        this.collect(new AddPrefix(gn, prefix, uriStr));
    }

    @Override
    public void deletePrefix(Node gn, String prefix) {
        this.collect(new DeletePrefix(gn, prefix));
    }

    @Override
    public void txnBegin() {
        this.collect(TxnBegin.object());
    }

    @Override
    public void txnCommit() {
        this.collect(TxnCommit.object());
    }

    @Override
    public void txnAbort() {
        this.collect(TxnAbort.object());
    }

    public static class RDFPatchStored
    implements RDFPatch {
        private final PatchHeader header;
        private final List<ChangeItem> actions;

        public RDFPatchStored(Map<String, Node> header, List<ChangeItem> actions) {
            this.header = new PatchHeader(header);
            this.actions = actions;
        }

        @Override
        public PatchHeader header() {
            return this.header;
        }

        @Override
        public void apply(RDFChanges changes) {
            this.header.apply(changes);
            this.actions.forEach(a -> RDFChangesCollector.enact(a, changes));
        }

        @Override
        public boolean repeatable() {
            return true;
        }

        public List<ChangeItem> getActions() {
            return this.actions;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.actions == null ? 0 : this.actions.hashCode());
            result = 31 * result + (this.header == null ? 0 : this.header.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RDFPatchStored other = (RDFPatchStored)obj;
            if (this.actions == null ? other.actions != null : !this.actions.equals(other.actions)) {
                return false;
            }
            return !(this.header == null ? other.header != null : !this.header.equals(other.header));
        }
    }
}

