/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf.model.impl;

import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.impl.ModelCom;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.shared.JenaException;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyImpl
extends ResourceImpl
implements Property {
    public static final Implementation factory = new Implementation(){

        @Override
        public boolean canWrap(Node n, EnhGraph eg) {
            return n.isURI();
        }

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            return new PropertyImpl(n, eg);
        }
    };
    protected static Logger logger = LoggerFactory.getLogger(PropertyImpl.class);
    protected int ordinal = -1;

    public PropertyImpl(String uri) {
        super(uri);
    }

    @Override
    public Property inModel(Model m4) {
        return this.getModel() == m4 ? this : m4.createProperty(this.getURI());
    }

    public PropertyImpl(String nameSpace, String localName) {
        super(nameSpace, localName);
    }

    public PropertyImpl(String uri, ModelCom m4) {
        super(uri, m4);
    }

    public PropertyImpl(String nameSpace, String localName, ModelCom m4) {
        super(nameSpace, localName, m4);
    }

    public PropertyImpl(Node n, EnhGraph m4) {
        super(n, m4);
    }

    public PropertyImpl(String nameSpace, String localName, int ordinal, ModelCom m4) {
        super(nameSpace, localName, m4);
    }

    @Override
    public boolean isProperty() {
        return true;
    }

    @Override
    public int getOrdinal() {
        if (this.ordinal < 0) {
            this.ordinal = this.computeOrdinal();
        }
        return this.ordinal;
    }

    private int computeOrdinal() {
        String localName = this.getLocalName();
        if (this.getNameSpace().equals(RDF.getURI()) && localName.matches("_[0-9]+")) {
            return this.parseInt(localName.substring(1));
        }
        return 0;
    }

    private int parseInt(String digits) {
        try {
            return Integer.parseInt(digits);
        }
        catch (NumberFormatException e2) {
            throw new JenaException("checkOrdinal fails on " + digits, e2);
        }
    }
}

