/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontology.impl;

import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Node;
import org.apache.jena.ontology.AllValuesFromRestriction;
import org.apache.jena.ontology.CardinalityRestriction;
import org.apache.jena.ontology.ConversionException;
import org.apache.jena.ontology.HasValueRestriction;
import org.apache.jena.ontology.MaxCardinalityRestriction;
import org.apache.jena.ontology.MinCardinalityRestriction;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntProperty;
import org.apache.jena.ontology.Profile;
import org.apache.jena.ontology.Restriction;
import org.apache.jena.ontology.SomeValuesFromRestriction;
import org.apache.jena.ontology.impl.OntClassImpl;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;

public class RestrictionImpl
extends OntClassImpl
implements Restriction {
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new RestrictionImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n + " to Restriction");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            Profile profile = eg instanceof OntModel ? ((OntModel)((Object)eg)).getProfile() : null;
            return profile != null && profile.isSupported(node, eg, Restriction.class);
        }
    };

    public RestrictionImpl(Node n, EnhGraph g2) {
        super(n, g2);
    }

    @Override
    public void setOnProperty(Property prop) {
        this.setPropertyValue(this.getProfile().ON_PROPERTY(), "ON_PROPERTY", prop);
    }

    @Override
    public OntProperty getOnProperty() {
        return this.objectAs(this.getProfile().ON_PROPERTY(), "ON_PROPERTY", OntProperty.class);
    }

    @Override
    public boolean onProperty(Property prop) {
        return this.hasPropertyValue(this.getProfile().ON_PROPERTY(), "ON_PROPERTY", prop);
    }

    @Override
    public void removeOnProperty(Property prop) {
        this.removePropertyValue(this.getProfile().ON_PROPERTY(), "ON_PROPERTY", prop);
    }

    @Override
    public AllValuesFromRestriction asAllValuesFromRestriction() {
        return this.as(AllValuesFromRestriction.class);
    }

    @Override
    public SomeValuesFromRestriction asSomeValuesFromRestriction() {
        return this.as(SomeValuesFromRestriction.class);
    }

    @Override
    public HasValueRestriction asHasValueRestriction() {
        return this.as(HasValueRestriction.class);
    }

    @Override
    public CardinalityRestriction asCardinalityRestriction() {
        return this.as(CardinalityRestriction.class);
    }

    @Override
    public MinCardinalityRestriction asMinCardinalityRestriction() {
        return this.as(MinCardinalityRestriction.class);
    }

    @Override
    public MaxCardinalityRestriction asMaxCardinalityRestriction() {
        return this.as(MaxCardinalityRestriction.class);
    }

    @Override
    public boolean isAllValuesFromRestriction() {
        this.checkProfile(this.getProfile().ALL_VALUES_FROM(), "ALL_VALUES_FROM");
        return this.hasProperty(this.getProfile().ALL_VALUES_FROM());
    }

    @Override
    public boolean isSomeValuesFromRestriction() {
        this.checkProfile(this.getProfile().SOME_VALUES_FROM(), "SOME_VALUES_FROM");
        return this.hasProperty(this.getProfile().SOME_VALUES_FROM());
    }

    @Override
    public boolean isHasValueRestriction() {
        this.checkProfile(this.getProfile().HAS_VALUE(), "HAS_VALUE");
        return this.hasProperty(this.getProfile().HAS_VALUE());
    }

    @Override
    public boolean isCardinalityRestriction() {
        this.checkProfile(this.getProfile().CARDINALITY(), "CARDINALITY");
        return this.hasProperty(this.getProfile().CARDINALITY());
    }

    @Override
    public boolean isMinCardinalityRestriction() {
        this.checkProfile(this.getProfile().MIN_CARDINALITY(), "MIN_CARDINALITY");
        return this.hasProperty(this.getProfile().MIN_CARDINALITY());
    }

    @Override
    public boolean isMaxCardinalityRestriction() {
        this.checkProfile(this.getProfile().MAX_CARDINALITY(), "MAX_CARDINALITY");
        return this.hasProperty(this.getProfile().MAX_CARDINALITY());
    }

    @Override
    public AllValuesFromRestriction convertToAllValuesFromRestriction(Resource cls) {
        this.setPropertyValue(this.getProfile().ALL_VALUES_FROM(), "ALL_VALUES_FROM", cls);
        return this.as(AllValuesFromRestriction.class);
    }

    @Override
    public SomeValuesFromRestriction convertToSomeValuesFromRestriction(Resource cls) {
        this.setPropertyValue(this.getProfile().SOME_VALUES_FROM(), "SOME_VALUES_FROM", cls);
        return this.as(SomeValuesFromRestriction.class);
    }

    @Override
    public HasValueRestriction convertToHasValueRestriction(RDFNode value) {
        this.setPropertyValue(this.getProfile().HAS_VALUE(), "HAS_VALUE", value);
        return this.as(HasValueRestriction.class);
    }

    @Override
    public CardinalityRestriction convertToCardinalityRestriction(int cardinality) {
        this.setPropertyValue(this.getProfile().CARDINALITY(), "CARDINALITY", this.getModel().createTypedLiteral(cardinality));
        return this.as(CardinalityRestriction.class);
    }

    @Override
    public MinCardinalityRestriction convertToMinCardinalityRestriction(int cardinality) {
        this.setPropertyValue(this.getProfile().MIN_CARDINALITY(), "MIN_CARDINALITY", this.getModel().createTypedLiteral(cardinality));
        return this.as(MinCardinalityRestriction.class);
    }

    @Override
    public MaxCardinalityRestriction convertToMaxCardinalityRestriction(int cardinality) {
        this.setPropertyValue(this.getProfile().MAX_CARDINALITY(), "MAX_CARDINALITY", this.getModel().createTypedLiteral(cardinality));
        return this.as(MaxCardinalityRestriction.class);
    }
}

