/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.AllCapabilities;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.graph.impl.SimpleEventManager;
import org.apache.jena.util.iterator.ExtendedIterator;

public class CollectionGraph
extends GraphBase {
    private final Collection<Triple> triples;
    private final boolean uniqueOnly;

    static boolean tripleContained(Triple patternTriple, Triple dataTriple) {
        return CollectionGraph.equalNode(patternTriple.getSubject(), dataTriple.getSubject()) && CollectionGraph.equalNode(patternTriple.getPredicate(), dataTriple.getPredicate()) && CollectionGraph.equalNode(patternTriple.getObject(), dataTriple.getObject());
    }

    private static boolean equalNode(Node m4, Node n) {
        n = CollectionGraph.fixupNode(n);
        return (m4 = CollectionGraph.fixupNode(m4)) == null || m4 == Node.ANY || m4.equals(n);
    }

    private static Node fixupNode(Node node) {
        String lang;
        if (node == null || node == Node.ANY) {
            return node;
        }
        if (node.isLiteral() && (lang = node.getLiteralLanguage()) != null && !lang.equals("")) {
            node = NodeFactory.createLiteral(node.getLiteralLexicalForm(), lang.toLowerCase(Locale.ROOT));
        }
        return node;
    }

    public CollectionGraph() {
        this(new HashSet<Triple>());
    }

    public CollectionGraph(Collection<Triple> triples) {
        this.triples = triples;
        this.uniqueOnly = triples instanceof Set;
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(Triple m4) {
        ExtendedIterator<Triple> iter = SimpleEventManager.notifyingRemove(this, this.triples.iterator());
        return iter.filterKeep(t2 -> CollectionGraph.tripleContained(m4, t2));
    }

    @Override
    public void performAdd(Triple t2) {
        if (this.uniqueOnly || !this.triples.contains(t2)) {
            this.triples.add(t2);
        }
    }

    @Override
    public void performDelete(Triple t2) {
        this.triples.remove(t2);
    }

    @Override
    public Capabilities getCapabilities() {
        return AllCapabilities.updateAllowed;
    }
}

