/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jena.graph.Node;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sys.Serializer;

public class Triple
implements Serializable {
    private final Node subj;
    private final Node pred;
    private final Node obj;
    public static final Triple ANY = new Triple(Node.ANY, Node.ANY, Node.ANY);

    @Deprecated
    public Triple(Node s2, Node p, Node o) {
        if (s2 == null) {
            throw new UnsupportedOperationException("subject cannot be null");
        }
        if (p == null) {
            throw new UnsupportedOperationException("predicate cannot be null");
        }
        if (o == null) {
            throw new UnsupportedOperationException("object cannot be null");
        }
        this.subj = s2;
        this.pred = p;
        this.obj = o;
    }

    public String toString() {
        return this.toString(PrefixMapping.Standard);
    }

    public String toString(PrefixMapping pm) {
        return this.subj.toString(pm, true) + " @" + this.pred.toString(pm, true) + " " + this.obj.toString(pm, true);
    }

    public final Node getSubject() {
        return this.subj;
    }

    public final Node getPredicate() {
        return this.pred;
    }

    public final Node getObject() {
        return this.obj;
    }

    public Node getMatchSubject() {
        return Triple.anyToNull(this.subj);
    }

    public Node getMatchPredicate() {
        return Triple.anyToNull(this.pred);
    }

    public Node getMatchObject() {
        return Triple.anyToNull(this.obj);
    }

    private static Node anyToNull(Node n) {
        return Node.ANY.equals(n) ? null : n;
    }

    private static Node nullToAny(Node n) {
        return n == null ? Node.ANY : n;
    }

    private static boolean isAny(Node n) {
        return n == null || Node.ANY.equals(n);
    }

    public boolean isConcrete() {
        return this.subj.isConcrete() && this.pred.isConcrete() && this.obj.isConcrete();
    }

    public boolean equals(Object o) {
        return o instanceof Triple && ((Triple)o).sameAs(this.subj, this.pred, this.obj);
    }

    public boolean sameAs(Node s2, Node p, Node o) {
        return this.subj.equals(s2) && this.pred.equals(p) && this.obj.equals(o);
    }

    public boolean matches(Triple other) {
        return other.matchedBy(this.subj, this.pred, this.obj);
    }

    public boolean matches(Node s2, Node p, Node o) {
        return this.subj.matches(s2) && this.pred.matches(p) && this.obj.matches(o);
    }

    private boolean matchedBy(Node s2, Node p, Node o) {
        return s2.matches(this.subj) && p.matches(this.pred) && o.matches(this.obj);
    }

    public boolean subjectMatches(Node s2) {
        return this.subj.matches(s2);
    }

    public boolean predicateMatches(Node p) {
        return this.pred.matches(p);
    }

    public boolean objectMatches(Node o) {
        return this.obj.matches(o);
    }

    protected Object writeReplace() throws ObjectStreamException {
        Function<Triple, Object> function = Serializer.getTripleSerializer();
        if (function == null) {
            throw new IllegalStateException("Function for Triple.writeReplace not set");
        }
        return function.apply(this);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new IllegalStateException();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new IllegalStateException();
    }

    public int hashCode() {
        return Triple.hashCode(this.subj, this.pred, this.obj);
    }

    public static int hashCode(Node s2, Node p, Node o) {
        return s2.hashCode() >> 1 ^ p.hashCode() ^ o.hashCode() << 1;
    }

    public static Triple create(Node s2, Node p, Node o) {
        if (Triple.isAny(s2) && Triple.isAny(p) && Triple.isAny(o)) {
            return ANY;
        }
        return new Triple(s2, p, o);
    }

    public static Triple createMatch(Node s2, Node p, Node o) {
        return Triple.create(Triple.nullToAny(s2), Triple.nullToAny(p), Triple.nullToAny(o));
    }

    public static abstract class Field {
        protected static final Predicate<Triple> anyTriple = t2 -> true;
        public static final Field fieldSubject = new Field(){

            @Override
            public Node getField(Triple t2) {
                return t2.subj;
            }

            @Override
            public Predicate<Triple> filterOn(Node n) {
                return n.isConcrete() ? x -> n.equals(x.subj) : anyTriple;
            }

            @Override
            public Predicate<Triple> filterOnConcrete(Node n) {
                return x -> n.equals(x.subj);
            }
        };
        public static final Field fieldObject = new Field(){

            @Override
            public Node getField(Triple t2) {
                return t2.obj;
            }

            @Override
            public Predicate<Triple> filterOn(Node n) {
                return n.isConcrete() ? x -> n.sameValueAs(x.obj) : anyTriple;
            }

            @Override
            public Predicate<Triple> filterOnConcrete(Node n) {
                return x -> n.sameValueAs(x.obj);
            }
        };
        public static final Field fieldPredicate = new Field(){

            @Override
            public Node getField(Triple t2) {
                return t2.pred;
            }

            @Override
            public Predicate<Triple> filterOn(Node n) {
                return n.isConcrete() ? x -> n.equals(x.pred) : anyTriple;
            }

            @Override
            public Predicate<Triple> filterOnConcrete(Node n) {
                return x -> n.equals(x.pred);
            }
        };

        public abstract Node getField(Triple var1);

        public abstract Predicate<Triple> filterOn(Node var1);

        public abstract Predicate<Triple> filterOnConcrete(Node var1);

        public final Predicate<Triple> filterOn(Triple t2) {
            return this.filterOn(this.getField(t2));
        }
    }
}

