/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.system;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.logging.LogCtlLog4j2;
import org.apache.jena.fuseki.Fuseki;

public class FusekiLogging {
    private static final String[] resourcesForLog4jProperties = new String[]{"log4j2.properties"};
    public static String envLogLoggingProperty = "FUSEKI_LOGLOGGING";
    public static String logLoggingProperty = "fuseki.logLogging";
    private static String logLoggingPropertyAlt = "fuseki.loglogging";
    private static final boolean LogLogging = FusekiLogging.getLogLogging();
    private static boolean loggingInitialized = false;
    public static final String log4j2_configurationFile = "log4j2.configurationFile";
    private static final String log4j2_configurationFileLegacy = "log4j.configurationFile";
    public static final String log4j2_web_configuration = "log4jConfiguration";

    private static final boolean getLogLogging() {
        String x = System.getProperty(logLoggingPropertyAlt);
        if (x != null) {
            FusekiLogging.logLogging("Old system property used '%s'", logLoggingPropertyAlt);
            return x.equalsIgnoreCase("true");
        }
        x = Lib.getenv("FUSEKI_LOGLOGGING", logLoggingProperty);
        return x != null && x.equalsIgnoreCase("true");
    }

    public static synchronized void markInitialized(boolean isInitialized) {
        FusekiLogging.logLogging("markInitialized(" + isInitialized + ")", new Object[0]);
        loggingInitialized = isInitialized;
    }

    public static synchronized void setLogging() {
        FusekiLogging.setLogging(null);
    }

    public static synchronized boolean hasInitialized() {
        return loggingInitialized;
    }

    public static synchronized void setLogging(Path extraDir) {
        if (loggingInitialized) {
            return;
        }
        loggingInitialized = true;
        FusekiLogging.logLogging("Set logging", new Object[0]);
        if (FusekiLogging.checkSystemProperties(log4j2_configurationFile) || FusekiLogging.checkSystemProperties(log4j2_configurationFileLegacy) || System.getenv("LOG4J_CONFIGURATION_FILE") != null) {
            FusekiLogging.logLogging("External log4j2 setup ", new Object[0]);
            return;
        }
        FusekiLogging.logLogging("Setup", new Object[0]);
        String fn1 = "log4j2.properties";
        String fn2 = null;
        if (extraDir != null) {
            fn2 = extraDir.resolve("log4j2.properties").toString();
        }
        if (FusekiLogging.attempt(fn1)) {
            return;
        }
        if (FusekiLogging.attempt(fn2)) {
            return;
        }
        for (String resourceName : resourcesForLog4jProperties) {
            InputStream inputStream;
            FusekiLogging.logLogging("Try classpath %s", resourceName);
            URL url = Thread.currentThread().getContextClassLoader().getResource(resourceName);
            if (url == null) continue;
            try {
                inputStream = url.openStream();
                try {
                    String string = IO.readWholeFileAsUTF8(inputStream);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (IOException ex) {
                IO.exception(ex);
            }
            try {
                inputStream = url.openStream();
                try {
                    FusekiLogging.loadConfiguration(inputStream, resourceName);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (IOException ex) {
                IO.exception(ex);
            }
            FusekiLogging.logLogging("Found via classpath %s", url);
            System.setProperty(log4j2_configurationFile, url.toString());
            return;
        }
        FusekiLogging.logLogging("Fallback built-in log4j2setup", new Object[0]);
        String dftLog4j = FusekiLogging.log4j2setupFallback();
        FusekiLogging.resetLogging(dftLog4j);
        System.setProperty(log4j2_configurationFile, "set");
    }

    private static boolean checkSystemProperties(String ... properties) {
        String x = null;
        for (String propertyName : properties) {
            x = System.getProperty(propertyName, null);
            if (x == null) continue;
            if ("set".equals(x)) {
                Fuseki.serverLog.warn("Fuseki logging: Unexpected: Log4j2 was setup by some other part of Jena");
                return true;
            }
            return true;
        }
        return false;
    }

    private static void loadConfiguration(InputStream inputStream, String resourceName) throws IOException {
        LogCtlLog4j2.resetLogging(inputStream, resourceName);
    }

    private static boolean attempt(String fn) {
        block10: {
            if (fn == null) {
                return false;
            }
            try {
                FusekiLogging.logLogging("Try file:" + fn, new Object[0]);
                File f = new File(fn);
                if (!f.exists()) break block10;
                FusekiLogging.logLogging("Found via file " + fn, new Object[0]);
                try (FileInputStream input = new FileInputStream(fn);){
                    FusekiLogging.loadConfiguration(input, fn);
                }
                catch (IOException ex) {
                    IO.exception(ex);
                }
                System.setProperty(log4j2_configurationFile, "file:" + fn);
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private static void logLogging(String fmt, Object ... args) {
        if (LogLogging) {
            System.err.print("Fuseki Logging: ");
            System.err.printf(fmt, args);
            System.err.println();
        }
    }

    private static String log4j2setupFallback() {
        return StrUtils.strjoinNL("## Plain output to stdout", "status = error", "name = FusekiLogging", "appender.console.type = Console", "appender.console.name = OUT", "appender.console.target = SYSTEM_OUT", "appender.console.layout.type = PatternLayout", "appender.console.layout.pattern = [%d{yyyy-MM-dd HH:mm:ss}] %-10c{1} %-5p %m%n", "", "rootLogger.level                  = WARN", "rootLogger.appenderRef.stdout.ref = OUT", "", "logger.jena.name  = org.apache.jena", "logger.jena.level = INFO", "", "logger.arq-exec.name  = org.apache.jena.arq.exec", "logger.arq-exec.level = INFO", "", "logger.riot.name  = org.apache.jena.riot", "logger.riot.level = INFO", "", "logger.fuseki.name  = org.apache.jena.fuseki", "logger.fuseki.level = INFO", "", "logger.fuseki-fuseki.name  = org.apache.jena.fuseki.Fuseki", "logger.fuseki-fuseki.level = INFO", "", "logger.fuseki-server.name  = org.apache.jena.fuseki.Server", "logger.fuseki-server.level = INFO", "", "logger.fuseki-config.name  = org.apache.jena.fuseki.Config", "logger.fuseki-config.level = INFO", "", "logger.fuseki-admin.name  = org.apache.jena.fuseki.Admin", "logger.fuseki-admin.level = INFO", "", "logger.jetty.name  = org.eclipse.jetty", "logger.jetty.level = WARN", "", "logger.apache-http.name   = org.apache.http", "logger.apache-http.level  = WARN", "logger.shiro.name = org.apache.shiro", "logger.shiro.level = WARN", "", "# Hide bug in Shiro 1.5.0", "logger.shiro-realm.name = org.apache.shiro.realm.text.IniRealm", "logger.shiro-realm.level = ERROR", "", "# This goes out in NCSA format", "appender.plain.type = Console", "appender.plain.name = PLAIN", "appender.plain.layout.type = PatternLayout", "appender.plain.layout.pattern = %m%n", "", "logger.fuseki-request.name                   = org.apache.jena.fuseki.Request", "logger.fuseki-request.additivity             = false", "logger.fuseki-request.level                  = OFF", "logger.fuseki-request.appenderRef.plain.ref  = PLAIN");
    }

    public static void resetLogging(String configString) {
        LogCtlLog4j2.resetLogging(configString);
    }
}

