/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mgt;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonBuilder;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.ctl.ActionCtl;
import org.apache.jena.fuseki.ctl.JsonDescription;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;

public class ActionServerStatus
extends ActionCtl {
    @Override
    public void validate(HttpAction action) {
    }

    @Override
    public void execGet(HttpAction action) {
        this.executeLifecycle(action);
    }

    @Override
    public void execPost(HttpAction action) {
        this.executeLifecycle(action);
    }

    @Override
    public void execute(HttpAction action) {
        try {
            this.description(action);
            ServletOps.success(action);
        }
        catch (IOException e2) {
            ServletOps.errorOccurred(e2);
        }
    }

    private void description(HttpAction action) throws IOException {
        ServletOutputStream out = action.getResponseOutputStream();
        action.setResponseContentType("application/json");
        action.setResponseCharacterEncoding("utf-8");
        JsonBuilder builder = new JsonBuilder();
        builder.startObject();
        this.describeServer(builder, action.getRequestLocalPort());
        this.describeDatasets(builder, action.getDataAccessPointRegistry());
        builder.finishObject();
        JsonValue v = builder.build();
        JSON.write(out, v);
        out.write(10);
        out.flush();
    }

    private void describeServer(JsonBuilder builder, int requestPort) {
        String versionStr = Fuseki.VERSION;
        builder.pair("version", versionStr).pair("startDateTime", Fuseki.serverStartedAt()).pair("uptime", Fuseki.serverUptimeSeconds());
    }

    private void describeDatasets(JsonBuilder builder, DataAccessPointRegistry registry) {
        builder.key("datasets");
        JsonDescription.arrayDatasets(builder, registry);
    }
}

