/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki;

import java.util.Calendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.atlas.lib.Version;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.query.ARQ;
import org.apache.jena.riot.system.stream.LocatorFTP;
import org.apache.jena.riot.system.stream.LocatorHTTP;
import org.apache.jena.riot.system.stream.StreamManager;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.MappingRegistry;
import org.apache.jena.sys.JenaSystem;
import org.apache.jena.tdb.TDB;
import org.apache.jena.tdb.transaction.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fuseki {
    public static String PATH = "org.apache.jena.fuseki";
    public static String FusekiIRI = "http://jena.apache.org/Fuseki";
    public static String FusekiSymbolIRI = "http://jena.apache.org/fuseki#";
    public static String PagesStatic = "pages";
    public static final String BaseParserSPARQL = "http://server/unset-base/";
    public static final String BaseUpload = "http://server/unset-base/";
    public static final boolean CORS_ENABLED = false;
    public static final String NAME = "Apache Jena Fuseki";
    public static final String VERSION = Version.versionForClass(Fuseki.class).orElse("<development>");
    public static final boolean GSP_DIRECT_NAMING = false;
    public static boolean developmentMode;
    public static boolean outputJettyServerHeader;
    public static boolean outputFusekiServerHeader;
    public static final String serverHttpName;
    public static final String actionLogName;
    public static final Logger actionLog;
    public static final String requestLogName;
    public static final Logger requestLog;
    public static final String adminLogName;
    public static final Logger adminLog;
    public static final String builderLogName;
    public static final Logger builderLog;
    public static final String validationLogName;
    public static final Logger validationLog;
    public static final String serverLogName;
    public static final Logger serverLog;
    public static final String servletRequestLogName;
    public static final String configLogName;
    public static final Logger configLog;
    public static final String backupLogName;
    public static final Logger backupLog;
    public static final String compactLogName;
    public static final Logger compactLog;
    public static boolean verboseLogging;
    public static final String attrVerbose = "org.apache.jena.fuseki:verbose";
    public static final String attrNameRegistry = "org.apache.jena.fuseki:DataAccessPointRegistry";
    public static final String attrOperationRegistry = "org.apache.jena.fuseki:OperationRegistry";
    public static final String attrAuthorizationService = "org.apache.jena.fuseki:AuthorizationService";
    public static final StreamManager webStreamManager;
    public static String FusekiRequestIdHeader;
    private static boolean initialized;
    private static final long startMillis;
    private static final Calendar cal;
    private static final String startDateTime;

    public static void setVerbose(ServletContext cxt, boolean verbose) {
        cxt.setAttribute(attrVerbose, verbose);
    }

    public static boolean getVerbose(ServletContext cxt) {
        Object x = cxt.getAttribute(attrVerbose);
        if (x == null) {
            return false;
        }
        if (x instanceof Boolean) {
            return (Boolean)x;
        }
        throw new FusekiException("attrVerbose: unknown object class: " + x.getClass().getName());
    }

    public static long serverUptimeMillis() {
        return System.currentTimeMillis() - startMillis;
    }

    public static long serverUptimeSeconds() {
        long x = System.currentTimeMillis() - startMillis;
        return TimeUnit.MILLISECONDS.toSeconds(x);
    }

    public static String serverStartedAt() {
        return startDateTime;
    }

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        JenaSystem.init();
        MappingRegistry.addPrefixMapping("fuseki", FusekiSymbolIRI);
        TDB.setOptimizerWarningFlag(false);
        TransactionManager.QueueBatchSize = 0;
    }

    public static Context getContext() {
        return ARQ.getContext();
    }

    static {
        outputJettyServerHeader = developmentMode = VERSION == null || VERSION.equals("development") || VERSION.contains("SNAPSHOT");
        outputFusekiServerHeader = developmentMode;
        serverHttpName = "Apache Jena Fuseki (" + VERSION + ")";
        actionLogName = PATH + ".Fuseki";
        actionLog = LoggerFactory.getLogger(actionLogName);
        requestLogName = PATH + ".Request";
        requestLog = LoggerFactory.getLogger(requestLogName);
        adminLogName = PATH + ".Admin";
        adminLog = LoggerFactory.getLogger(adminLogName);
        builderLogName = PATH + ".Builder";
        builderLog = LoggerFactory.getLogger(builderLogName);
        validationLogName = PATH + ".Validate";
        validationLog = LoggerFactory.getLogger(adminLogName);
        serverLogName = PATH + ".Server";
        serverLog = LoggerFactory.getLogger(serverLogName);
        servletRequestLogName = PATH + ".Servlet";
        configLogName = PATH + ".Config";
        configLog = LoggerFactory.getLogger(configLogName);
        backupLogName = PATH + ".Backup";
        backupLog = LoggerFactory.getLogger(backupLogName);
        compactLogName = PATH + ".Compact";
        compactLog = LoggerFactory.getLogger(compactLogName);
        verboseLogging = false;
        webStreamManager = new StreamManager();
        webStreamManager.addLocator(new LocatorHTTP());
        webStreamManager.addLocator(new LocatorFTP());
        FusekiRequestIdHeader = "Fuseki-Request-Id";
        initialized = false;
        startMillis = System.currentTimeMillis();
        cal = Calendar.getInstance(TimeZone.getTimeZone("00:00"));
        cal.setTimeInMillis(startMillis);
        startDateTime = DateTimeUtils.calendarToXSDDateTimeString(cal);
    }
}

