/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.storage.system;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.dboe.storage.DatabaseRDF;
import org.apache.jena.dboe.storage.StoragePrefixes;
import org.apache.jena.dboe.storage.StorageRDF;
import org.apache.jena.dboe.storage.prefixes.PrefixesDboeFactory;
import org.apache.jena.dboe.storage.prefixes.StoragePrefixMap;
import org.apache.jena.dboe.storage.prefixes.StoragePrefixesView;
import org.apache.jena.dboe.storage.system.GraphViewStorage;
import org.apache.jena.dboe.transaction.txn.IteratorTxnTracker;
import org.apache.jena.dboe.transaction.txn.TransactionalSystem;
import org.apache.jena.dboe.transaction.txn.TxnId;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.sparql.core.DatasetGraphBaseFind;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;

public class DatasetGraphStorage
extends DatasetGraphBaseFind
implements DatabaseRDF {
    private final Transactional txn;
    private final StorageRDF storage;
    private final StoragePrefixes prefixes;
    private final PrefixMap prefixMap;

    @Override
    public void begin() {
        this.txn.begin();
    }

    @Override
    public void begin(TxnType txnType) {
        this.txn.begin(txnType);
    }

    @Override
    public void begin(ReadWrite mode) {
        this.txn.begin(mode);
    }

    @Override
    public boolean promote(Transactional.Promote mode) {
        return this.txn.promote(mode);
    }

    @Override
    public void commit() {
        this.txn.commit();
    }

    @Override
    public void abort() {
        this.txn.abort();
    }

    @Override
    public boolean isInTransaction() {
        return this.txn.isInTransaction();
    }

    @Override
    public void end() {
        this.txn.end();
    }

    @Override
    public ReadWrite transactionMode() {
        return this.txn.transactionMode();
    }

    @Override
    public TxnType transactionType() {
        return this.txn.transactionType();
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsTransactionAbort() {
        return false;
    }

    public DatasetGraphStorage(StorageRDF storage, StoragePrefixes prefixes, Transactional transactional) {
        this.storage = storage;
        this.prefixes = prefixes;
        StoragePrefixMap spm = StoragePrefixesView.viewDataset(prefixes);
        this.prefixMap = PrefixesDboeFactory.newPrefixMap(spm);
        this.txn = transactional;
    }

    @Override
    public StorageRDF getData() {
        return this.storage;
    }

    @Override
    public StoragePrefixes getStoragePrefixes() {
        return this.prefixes;
    }

    @Override
    public Transactional getTransactional() {
        return this.txn;
    }

    @Override
    public PrefixMap prefixes() {
        return this.prefixMap;
    }

    @Override
    public Iterator<Node> listGraphNodes() {
        Iterator<Quad> iter = this.findNG(null, null, null, null);
        return Iter.iter(iter).map(Quad::getGraph).distinct();
    }

    private <T> Iterator<T> isolate(Iterator<T> iterator) {
        if (this.txn.isInTransaction() && this.txn instanceof TransactionalSystem) {
            TransactionalSystem txnSystem = (TransactionalSystem)this.txn;
            TxnId txnId = txnSystem.getThreadTransaction().getTxnId();
            return new IteratorTxnTracker<T>(iterator, txnSystem, txnId);
        }
        return Iter.iterator(iterator);
    }

    private Iterator<Triple> findStorage(Node s2, Node p, Node o) {
        return this.isolate(this.storage.find(s2, p, o));
    }

    private Iterator<Quad> findStorage(Node g2, Node s2, Node p, Node o) {
        return this.isolate(this.storage.find(g2, s2, p, o));
    }

    @Override
    protected Iterator<Quad> findInDftGraph(Node s2, Node p, Node o) {
        return Iter.map(this.findStorage(s2, p, o), t2 -> Quad.create(Quad.defaultGraphIRI, t2));
    }

    @Override
    protected Iterator<Quad> findInSpecificNamedGraph(Node g2, Node s2, Node p, Node o) {
        return this.findStorage(g2, s2, p, o);
    }

    @Override
    protected Iterator<Quad> findInAnyNamedGraphs(Node s2, Node p, Node o) {
        return this.findStorage(Node.ANY, s2, p, o);
    }

    @Override
    public Graph getDefaultGraph() {
        return GraphViewStorage.createDefaultGraphStorage(this, this.prefixes);
    }

    @Override
    public Graph getUnionGraph() {
        return GraphViewStorage.createUnionGraphStorage(this, this.prefixes);
    }

    @Override
    public Graph getGraph(Node graphNode) {
        return GraphViewStorage.createNamedGraphStorage(this, graphNode, this.prefixes);
    }

    @Override
    public void add(Quad quad) {
        if (Quad.isDefaultGraph(quad.getGraph())) {
            this.storage.add(quad.getSubject(), quad.getPredicate(), quad.getObject());
        } else {
            this.storage.add(quad);
        }
    }

    @Override
    public void delete(Quad quad) {
        if (Quad.isDefaultGraph(quad.getGraph())) {
            this.storage.delete(quad.getSubject(), quad.getPredicate(), quad.getObject());
        } else {
            this.storage.delete(quad);
        }
    }

    @Override
    public void add(Node g2, Node s2, Node p, Node o) {
        if (Quad.isUnionGraph(g2)) {
            throw new AddDeniedException("Can't add to the union graph");
        }
        if (g2 == null || Quad.isDefaultGraph(g2)) {
            this.storage.add(s2, p, o);
        } else {
            this.storage.add(g2, s2, p, o);
        }
    }

    @Override
    public void delete(Node g2, Node s2, Node p, Node o) {
        if (Quad.isUnionGraph(g2)) {
            throw new DeleteDeniedException("Can't remove from the union graph");
        }
        if (g2 == null || Quad.isDefaultGraph(g2)) {
            this.storage.delete(s2, p, o);
        } else {
            this.storage.delete(g2, s2, p, o);
        }
    }

    @Override
    public void addGraph(Node graphName, Graph graph) {
        graph.find(null, null, null).forEachRemaining(t2 -> this.add(graphName, t2.getSubject(), t2.getPredicate(), t2.getObject()));
        graph.getPrefixMapping().getNsPrefixMap().forEach((p, u) -> this.prefixes.add(graphName, (String)p, (String)u));
    }

    @Override
    public void removeGraph(Node graphName) {
        this.storage.removeAll(graphName, Node.ANY, Node.ANY, Node.ANY);
        this.prefixes.deleteAll(graphName);
    }

    @Override
    public long size() {
        return this.stream().map(Quad::getGraph).filter(gn -> !Quad.isDefaultGraph(gn)).distinct().count();
    }

    @Override
    public String toString() {
        return "DB: " + this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this));
    }
}

