/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.json.io.parser;

import org.apache.jena.atlas.iterator.PeekIterator;
import org.apache.jena.atlas.json.JsonParseException;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.TokenType;
import org.apache.jena.riot.tokens.Tokenizer;

class JSONParserBase {
    protected boolean VERBOSE = true;
    private Tokenizer tokens;
    private PeekIterator<Token> peekTokens;
    protected long currLine = -1L;
    protected long currCol = -1L;
    private Token tokenEOF = null;

    protected JSONParserBase(Tokenizer tokens2) {
        this.tokens = tokens2;
        this.peekTokens = new PeekIterator<Token>(tokens2);
    }

    protected final boolean eof() {
        if (this.tokenEOF != null) {
            return true;
        }
        if (!this.moreTokens()) {
            this.tokenEOF = new Token(this.tokens.getLine(), this.tokens.getColumn());
            return true;
        }
        return false;
    }

    protected final boolean moreTokens() {
        return this.peekTokens.hasNext();
    }

    protected final boolean lookingAt(TokenType tokenType) {
        Token t2 = this.peekTokens.peek();
        if (t2 == null) {
            return tokenType == TokenType.EOF;
        }
        return t2.hasType(tokenType);
    }

    protected final boolean lookingAtKeyString() {
        Token t2 = this.peekTokens.peek();
        if (t2 == null) {
            return false;
        }
        return t2.hasType(TokenType.STRING) && !t2.isLongString();
    }

    protected final boolean lookingAtNumber() {
        Token t2 = this.peekTokens.peek();
        if (t2 == null) {
            return false;
        }
        if (t2.hasType(TokenType.INTEGER)) {
            return true;
        }
        if (t2.hasType(TokenType.HEX)) {
            return true;
        }
        if (t2.hasType(TokenType.DECIMAL)) {
            return true;
        }
        return t2.hasType(TokenType.DOUBLE);
    }

    protected final Token peekToken() {
        if (this.eof()) {
            return this.tokenEOF;
        }
        return this.peekTokens.element();
    }

    protected final Token nextToken() {
        if (this.eof()) {
            return this.tokenEOF;
        }
        Token t2 = this.peekTokens.next();
        this.currLine = t2.getLine();
        this.currCol = t2.getColumn();
        return t2;
    }

    protected final void expectOrEOF(String msg, TokenType tokenType) {
        if (this.eof()) {
            return;
        }
        this.expect(msg, tokenType);
    }

    protected final void expect(String msg, TokenType ttype) {
        if (!this.lookingAt(ttype)) {
            this.exception(msg, new Object[0]);
        }
        this.nextToken();
    }

    protected final void exception(String msg, Object ... args) {
        throw new JsonParseException(String.format(msg, args), (int)this.tokens.getLine(), (int)this.tokens.getColumn());
    }
}

