/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io.doubleparser;

import com.fasterxml.jackson.core.io.doubleparser.AbstractNumberParser;
import com.fasterxml.jackson.core.io.doubleparser.FastDoubleSwar;
import com.fasterxml.jackson.core.io.doubleparser.FastIntegerMath;
import com.fasterxml.jackson.core.io.doubleparser.ParseDigitsTaskCharSequence;
import java.math.BigInteger;
import java.util.NavigableMap;

class JavaBigIntegerFromCharSequence
extends AbstractNumberParser {
    public static final int MAX_INPUT_LENGTH = 1292782622;
    private static final int MAX_DECIMAL_DIGITS = 646456993;
    private static final int MAX_HEX_DIGITS = 0x20000000;

    JavaBigIntegerFromCharSequence() {
    }

    public BigInteger parseBigIntegerLiteral(CharSequence str2, int offset, int length, int radix) throws NumberFormatException {
        try {
            boolean isNegative;
            int endIndex = offset + length;
            if (offset < 0 || endIndex < offset || endIndex > str2.length() || length > 1292782622) {
                throw new IllegalArgumentException("offset < 0 or length > str.length");
            }
            int index = offset;
            char ch = str2.charAt(index);
            boolean bl = isNegative = ch == '-';
            if ((isNegative || ch == '+') && (ch = JavaBigIntegerFromCharSequence.charAt(str2, ++index, endIndex)) == '\u0000') {
                throw new NumberFormatException("illegal syntax");
            }
            switch (radix) {
                case 10: {
                    return this.parseDecDigits(str2, index, endIndex, isNegative);
                }
                case 16: {
                    return this.parseHexDigits(str2, index, endIndex, isNegative);
                }
            }
            return new BigInteger(str2.subSequence(offset, length).toString(), radix);
        }
        catch (ArithmeticException e2) {
            NumberFormatException nfe = new NumberFormatException("value exceeds limits");
            nfe.initCause(e2);
            throw nfe;
        }
    }

    private BigInteger parseDecDigits(CharSequence str2, int from, int to, boolean isNegative) {
        int numDigits = to - from;
        if (numDigits > 18) {
            return this.parseManyDecDigits(str2, from, to, isNegative);
        }
        int preroll = from + (numDigits & 7);
        long significand = FastDoubleSwar.tryToParseUpTo7Digits(str2, from, preroll);
        boolean success = significand >= 0L;
        for (from = preroll; from < to; from += 8) {
            int addend = FastDoubleSwar.tryToParseEightDigits(str2, from);
            success &= addend >= 0;
            significand = significand * 100000000L + (long)addend;
        }
        if (!success) {
            throw new NumberFormatException("illegal syntax");
        }
        return BigInteger.valueOf(isNegative ? -significand : significand);
    }

    private BigInteger parseHexDigits(CharSequence str2, int from, int to, boolean isNegative) {
        int numDigits = to - (from = this.skipZeroes(str2, from, to));
        if (numDigits <= 0) {
            return BigInteger.ZERO;
        }
        if (numDigits > 0x20000000) {
            throw new NumberFormatException("value exceeds limits");
        }
        byte[] bytes = new byte[(numDigits + 1 >> 1) + 1];
        int index = 1;
        boolean illegalDigits = false;
        if ((numDigits & 1) != 0) {
            char chLow = str2.charAt(from++);
            int valueLow = JavaBigIntegerFromCharSequence.lookupHex(chLow);
            bytes[index++] = (byte)valueLow;
            illegalDigits = valueLow < 0;
        }
        int prerollLimit = from + (to - from & 7);
        while (from < prerollLimit) {
            char chHigh = str2.charAt(from);
            char chLow = str2.charAt(from + 1);
            int valueHigh = JavaBigIntegerFromCharSequence.lookupHex(chHigh);
            int valueLow = JavaBigIntegerFromCharSequence.lookupHex(chLow);
            bytes[index++] = (byte)(valueHigh << 4 | valueLow);
            illegalDigits |= valueLow < 0 || valueHigh < 0;
            from += 2;
        }
        while (from < to) {
            long value = FastDoubleSwar.tryToParseEightHexDigits(str2, from);
            FastDoubleSwar.writeIntBE(bytes, index, (int)value);
            illegalDigits |= value < 0L;
            from += 8;
            index += 4;
        }
        if (illegalDigits) {
            throw new NumberFormatException("illegal syntax");
        }
        BigInteger result = new BigInteger(bytes);
        return isNegative ? result.negate() : result;
    }

    private BigInteger parseManyDecDigits(CharSequence str2, int from, int to, boolean isNegative) {
        int numDigits = to - (from = this.skipZeroes(str2, from, to));
        if (numDigits > 646456993) {
            throw new NumberFormatException("value exceeds limits");
        }
        NavigableMap<Integer, BigInteger> powersOfTen = FastIntegerMath.fillPowersOf10Floor16(from, to);
        BigInteger result = ParseDigitsTaskCharSequence.parseDigitsRecursive(str2, from, to, powersOfTen);
        return isNegative ? result.negate() : result;
    }

    private int skipZeroes(CharSequence str2, int from, int to) {
        while (from < to && str2.charAt(from) == '0') {
            ++from;
        }
        return from;
    }
}

