/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rfc3986;

import java.util.HashMap;
import org.apache.jena.rfc3986.Issue;
import org.apache.jena.rfc3986.Severity;
import org.apache.jena.rfc3986.SeverityMap;

public class Violations {
    public static final SeverityMap globalDftLevels = Violations.systemSettings();
    public static final SeverityMap strictLevels = Violations.allErrorSettings();
    private static SeverityMap levels = globalDftLevels;

    public static SeverityMap severities() {
        return levels;
    }

    public static Severity getSeverity(Issue issue) {
        return levels.getOrDefault(issue, Severity.INVALID);
    }

    public static Severity getSeverity(SeverityMap severityMap, Issue issue) {
        return severityMap.getOrDefault(issue, Severity.INVALID);
    }

    public static void setSystemSeverityMap(SeverityMap newSeverityMap) {
        levels = newSeverityMap;
    }

    public static void reset() {
        Violations.setSystemSeverityMap(globalDftLevels);
    }

    private static SeverityMap systemSettings() {
        HashMap<Issue, Severity> severityMap = new HashMap<Issue, Severity>();
        SeverityMap.setSeverity(severityMap, Issue.ParseError, Severity.INVALID);
        SeverityMap.setSeverity(severityMap, Issue.iri_percent_not_uppercase, Severity.WARNING);
        SeverityMap.setSeverity(severityMap, Issue.iri_host_not_lowercase, Severity.WARNING);
        SeverityMap.setSeverity(severityMap, Issue.iri_user_info_present, Severity.WARNING);
        SeverityMap.setSeverity(severityMap, Issue.iri_password, Severity.ERROR);
        SeverityMap.setSeverity(severityMap, Issue.iri_bad_ipv4_address, Severity.WARNING);
        SeverityMap.setSeverity(severityMap, Issue.iri_bad_ipv6_address, Severity.WARNING);
        SeverityMap.setSeverity(severityMap, Issue.iri_bad_dot_segments, Severity.WARNING);
        SeverityMap.setSeverity(severityMap, Issue.iri_scheme_name_is_not_lowercase, Severity.WARNING);
        SeverityMap.setSeverity(severityMap, Issue.iri_scheme_expected, Severity.ERROR);
        SeverityMap.setSeverity(severityMap, Issue.iri_scheme_unexpected, Severity.ERROR);
        SeverityMap.setSeverity(severityMap, Issue.http_no_host, Severity.ERROR);
        SeverityMap.setSeverity(severityMap, Issue.http_empty_host, Severity.ERROR);
        SeverityMap.setSeverity(severityMap, Issue.http_empty_port, Severity.ERROR);
        SeverityMap.setSeverity(severityMap, Issue.http_port_not_advised, Severity.WARNING);
        SeverityMap.setSeverity(severityMap, Issue.http_omit_well_known_port, Severity.ERROR);
        SeverityMap.setSeverity(severityMap, Issue.uuid_bad_pattern, Severity.ERROR);
        SeverityMap.setSeverity(severityMap, Issue.uuid_has_query, Severity.ERROR);
        SeverityMap.setSeverity(severityMap, Issue.uuid_has_fragment, Severity.ERROR);
        SeverityMap.setSeverity(severityMap, Issue.uuid_not_lowercase, Severity.ERROR);
        SeverityMap.setSeverity(severityMap, Issue.uuid_scheme_not_registered, Severity.WARNING);
        SeverityMap.setSeverity(severityMap, Issue.urn_bad_pattern, Severity.ERROR);
        SeverityMap.setSeverity(severityMap, Issue.urn_bad_nid, Severity.ERROR);
        SeverityMap.setSeverity(severityMap, Issue.urn_bad_nss, Severity.ERROR);
        SeverityMap.setSeverity(severityMap, Issue.urn_bad_components, Severity.ERROR);
        SeverityMap.setSeverity(severityMap, Issue.urn_non_ascii_character, Severity.ERROR);
        SeverityMap.setSeverity(severityMap, Issue.urn_x_namespace, Severity.WARNING);
        SeverityMap.setSeverity(severityMap, Issue.urn_bad_informal_namespace, Severity.WARNING);
        SeverityMap.setSeverity(severityMap, Issue.file_bad_form, Severity.WARNING);
        SeverityMap.setSeverity(severityMap, Issue.file_relative_path, Severity.WARNING);
        SeverityMap.setSeverity(severityMap, Issue.did_bad_syntax, Severity.ERROR);
        SeverityMap.setSeverity(severityMap, Issue.oid_bad_syntax, Severity.ERROR);
        SeverityMap.setSeverity(severityMap, Issue.oid_scheme_not_registered, Severity.WARNING);
        return SeverityMap.create("IRI3986 SystemSettings", severityMap);
    }

    private static SeverityMap allErrorSettings() {
        HashMap<Issue, Severity> severityMap = new HashMap<Issue, Severity>();
        for (Issue issue : Issue.values()) {
            SeverityMap.setSeverity(severityMap, issue, Severity.ERROR);
        }
        SeverityMap.setSeverity(severityMap, Issue.ParseError, Severity.INVALID);
        return SeverityMap.create("All errors", severityMap);
    }
}

