/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.mem2.spliterator;

import java.util.Spliterator;
import java.util.function.Consumer;
import org.apache.jena.mem2.collection.FastHashSet;

public class SparseArrayIndexedSpliterator<E>
implements Spliterator<FastHashSet.IndexedKey<E>> {
    private final E[] entries;
    private int currentPositionMinusOne;
    private final int toIndexExclusive;
    private final Runnable checkForConcurrentModification;

    public SparseArrayIndexedSpliterator(E[] entries, int fromIndexInclusive, int toIndexExclusive, Runnable checkForConcurrentModification) {
        this.entries = entries;
        this.currentPositionMinusOne = fromIndexInclusive - 1;
        this.toIndexExclusive = toIndexExclusive;
        this.checkForConcurrentModification = checkForConcurrentModification;
    }

    public SparseArrayIndexedSpliterator(E[] entries, int toIndexExclusive, Runnable checkForConcurrentModification) {
        this(entries, 0, toIndexExclusive, checkForConcurrentModification);
    }

    public SparseArrayIndexedSpliterator(E[] entries, Runnable checkForConcurrentModification) {
        this(entries, entries.length, checkForConcurrentModification);
    }

    @Override
    public boolean tryAdvance(Consumer<? super FastHashSet.IndexedKey<E>> action) {
        this.checkForConcurrentModification.run();
        while (this.toIndexExclusive > ++this.currentPositionMinusOne) {
            if (null == this.entries[this.currentPositionMinusOne]) continue;
            action.accept(new FastHashSet.IndexedKey<E>(this.currentPositionMinusOne, this.entries[this.currentPositionMinusOne]));
            return true;
        }
        return false;
    }

    @Override
    public void forEachRemaining(Consumer<? super FastHashSet.IndexedKey<E>> action) {
        while (this.toIndexExclusive > ++this.currentPositionMinusOne) {
            if (null == this.entries[this.currentPositionMinusOne]) continue;
            action.accept(new FastHashSet.IndexedKey<E>(this.currentPositionMinusOne, this.entries[this.currentPositionMinusOne]));
        }
        this.checkForConcurrentModification.run();
    }

    @Override
    public Spliterator<FastHashSet.IndexedKey<E>> trySplit() {
        int nextPos = this.currentPositionMinusOne + 1;
        int remaining = this.toIndexExclusive - nextPos;
        if (remaining < 2) {
            return null;
        }
        int mid = nextPos + (remaining >>> 1);
        int fromIndexInclusive = nextPos;
        this.currentPositionMinusOne = mid - 1;
        return new SparseArrayIndexedSpliterator<E>(this.entries, fromIndexInclusive, mid, this.checkForConcurrentModification);
    }

    @Override
    public long estimateSize() {
        return (long)this.toIndexExclusive - (long)this.currentPositionMinusOne;
    }

    @Override
    public int characteristics() {
        return 1281;
    }
}

