/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ext.xerces.impl.dv.xs;

import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.jena.ext.xerces.impl.dv.InvalidDatatypeFacetException;
import org.apache.jena.ext.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.jena.ext.xerces.impl.dv.ValidatedInfo;
import org.apache.jena.ext.xerces.impl.dv.XSFacets;
import org.apache.jena.ext.xerces.impl.dv.XSSimpleType;
import org.apache.jena.ext.xerces.impl.dv.xs.AnyAtomicDV;
import org.apache.jena.ext.xerces.impl.dv.xs.AnySimpleDV;
import org.apache.jena.ext.xerces.impl.dv.xs.AnyURIDV;
import org.apache.jena.ext.xerces.impl.dv.xs.Base64BinaryDV;
import org.apache.jena.ext.xerces.impl.dv.xs.BooleanDV;
import org.apache.jena.ext.xerces.impl.dv.xs.DateDV;
import org.apache.jena.ext.xerces.impl.dv.xs.DateTimeDV;
import org.apache.jena.ext.xerces.impl.dv.xs.DateTimeStampDV;
import org.apache.jena.ext.xerces.impl.dv.xs.DayDV;
import org.apache.jena.ext.xerces.impl.dv.xs.DayTimeDurationDV;
import org.apache.jena.ext.xerces.impl.dv.xs.DecimalDV;
import org.apache.jena.ext.xerces.impl.dv.xs.DoubleDV;
import org.apache.jena.ext.xerces.impl.dv.xs.DurationDV;
import org.apache.jena.ext.xerces.impl.dv.xs.FloatDV;
import org.apache.jena.ext.xerces.impl.dv.xs.HexBinaryDV;
import org.apache.jena.ext.xerces.impl.dv.xs.IntegerDV;
import org.apache.jena.ext.xerces.impl.dv.xs.MonthDV;
import org.apache.jena.ext.xerces.impl.dv.xs.MonthDayDV;
import org.apache.jena.ext.xerces.impl.dv.xs.PrecisionDecimalDV;
import org.apache.jena.ext.xerces.impl.dv.xs.StringDV;
import org.apache.jena.ext.xerces.impl.dv.xs.TimeDV;
import org.apache.jena.ext.xerces.impl.dv.xs.TypeValidator;
import org.apache.jena.ext.xerces.impl.dv.xs.YearDV;
import org.apache.jena.ext.xerces.impl.dv.xs.YearMonthDV;
import org.apache.jena.ext.xerces.impl.dv.xs.YearMonthDurationDV;
import org.apache.jena.ext.xerces.util.XercesXMLChar;
import org.apache.jena.ext.xerces.xs.XSTypeDefinition;

public class XSSimpleTypeDecl
implements XSSimpleType {
    protected static final short DV_ANYSIMPLETYPE = 0;
    protected static final short DV_STRING = 1;
    protected static final short DV_BOOLEAN = 2;
    protected static final short DV_DECIMAL = 3;
    protected static final short DV_FLOAT = 4;
    protected static final short DV_DOUBLE = 5;
    protected static final short DV_DURATION = 6;
    protected static final short DV_DATETIME = 7;
    protected static final short DV_TIME = 8;
    protected static final short DV_DATE = 9;
    protected static final short DV_GYEARMONTH = 10;
    protected static final short DV_GYEAR = 11;
    protected static final short DV_GMONTHDAY = 12;
    protected static final short DV_GDAY = 13;
    protected static final short DV_GMONTH = 14;
    protected static final short DV_HEXBINARY = 15;
    protected static final short DV_BASE64BINARY = 16;
    protected static final short DV_ANYURI = 17;
    protected static final short DV_PRECISIONDECIMAL = 18;
    protected static final short DV_INTEGER = 19;
    protected static final short DV_YEARMONTHDURATION = 20;
    protected static final short DV_DAYTIMEDURATION = 21;
    protected static final short DV_ANYATOMICTYPE = 22;
    protected static final short DV_DATETIMESTAMP = 23;
    private static final TypeValidator[] gDVs = new TypeValidator[]{new AnySimpleDV(), new StringDV(), new BooleanDV(), new DecimalDV(), new FloatDV(), new DoubleDV(), new DurationDV(), new DateTimeDV(), new TimeDV(), new DateDV(), new YearMonthDV(), new YearDV(), new MonthDayDV(), new DayDV(), new MonthDV(), new HexBinaryDV(), new Base64BinaryDV(), new AnyURIDV(), new PrecisionDecimalDV(), new IntegerDV(), new YearMonthDurationDV(), new DayTimeDurationDV(), new AnyAtomicDV(), new DateTimeStampDV()};
    static final short NORMALIZE_NONE = 0;
    static final short NORMALIZE_TRIM = 1;
    static final short NORMALIZE_FULL = 2;
    static final short[] fDVNormalizeType = new short[]{0, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0};
    static final short SPECIAL_PATTERN_NONE = 0;
    static final short SPECIAL_PATTERN_NMTOKEN = 1;
    static final short SPECIAL_PATTERN_NAME = 2;
    static final short SPECIAL_PATTERN_NCNAME = 3;
    static final String[] SPECIAL_PATTERN_STRING = new String[]{"NONE", "NMTOKEN", "Name", "NCName"};
    static final String[] WS_FACET_STRING = new String[]{"preserve", "replace", "collapse"};
    static final String URI_SCHEMAFORSCHEMA = "http://www.w3.org/2001/XMLSchema";
    private final TypeValidator[] fDVs = gDVs;
    private boolean fIsImmutable = false;
    private short fBuiltInKind;
    private String fTypeName;
    private String fTargetNamespace;
    private XSSimpleTypeDecl fBase;
    private short fVariety = (short)-1;
    private short fValidationDV = (short)-1;
    private short fFacetsDefined = 0;
    private short fFixedFacet = 0;
    private short fWhiteSpace = 0;
    private int fLength = -1;
    private int fMinLength = -1;
    private int fMaxLength = -1;
    private int fTotalDigits = -1;
    private int fFractionDigits = -1;
    private Vector fPattern;
    private Vector fPatternStr;
    private ValidatedInfo[] fEnumeration;
    private int fEnumerationSize;
    private Object fMaxInclusive;
    private Object fMaxExclusive;
    private Object fMinExclusive;
    private Object fMinInclusive;
    private short fPatternType = 0;
    private short fOrdered;
    private boolean fFinite;
    private boolean fNumeric;
    static final XSSimpleTypeDecl fAnySimpleType = new XSSimpleTypeDecl(null, "anySimpleType", 0, 0, true, false, true, 1);

    public XSSimpleTypeDecl() {
    }

    protected XSSimpleTypeDecl(XSSimpleTypeDecl base, String name, short validateDV, short ordered, boolean finite, boolean numeric, boolean isImmutable, short builtInKind) {
        this.fIsImmutable = isImmutable;
        this.fBase = base;
        this.fTypeName = name;
        this.fTargetNamespace = URI_SCHEMAFORSCHEMA;
        this.fVariety = 1;
        this.fValidationDV = validateDV;
        this.fFacetsDefined = (short)16;
        if (validateDV == 0 || validateDV == 22 || validateDV == 1) {
            this.fWhiteSpace = 0;
        } else {
            this.fWhiteSpace = (short)2;
            this.fFixedFacet = (short)16;
        }
        this.fOrdered = ordered;
        this.fFinite = finite;
        this.fNumeric = numeric;
        this.fBuiltInKind = builtInKind;
    }

    protected XSSimpleTypeDecl(XSSimpleTypeDecl base, String name, String uri, boolean isImmutable, short builtInKind) {
        this(base, name, uri, isImmutable);
        this.fBuiltInKind = builtInKind;
    }

    protected XSSimpleTypeDecl(XSSimpleTypeDecl base, String name, String uri, boolean isImmutable) {
        this.fBase = base;
        this.fTypeName = name;
        this.fTargetNamespace = uri;
        this.fVariety = this.fBase.fVariety;
        this.fValidationDV = this.fBase.fValidationDV;
        this.fLength = this.fBase.fLength;
        this.fMinLength = this.fBase.fMinLength;
        this.fMaxLength = this.fBase.fMaxLength;
        this.fPattern = this.fBase.fPattern;
        this.fPatternStr = this.fBase.fPatternStr;
        this.fEnumeration = this.fBase.fEnumeration;
        this.fEnumerationSize = this.fBase.fEnumerationSize;
        this.fWhiteSpace = this.fBase.fWhiteSpace;
        this.fMaxExclusive = this.fBase.fMaxExclusive;
        this.fMaxInclusive = this.fBase.fMaxInclusive;
        this.fMinExclusive = this.fBase.fMinExclusive;
        this.fMinInclusive = this.fBase.fMinInclusive;
        this.fTotalDigits = this.fBase.fTotalDigits;
        this.fFractionDigits = this.fBase.fFractionDigits;
        this.fPatternType = this.fBase.fPatternType;
        this.fFixedFacet = this.fBase.fFixedFacet;
        this.fFacetsDefined = this.fBase.fFacetsDefined;
        this.calcFundamentalFacets();
        this.fIsImmutable = isImmutable;
        this.fBuiltInKind = base.fBuiltInKind;
    }

    @Override
    public String getName() {
        return this.fTypeName;
    }

    @Override
    public String getNamespace() {
        return this.fTargetNamespace;
    }

    @Override
    public XSTypeDefinition getBaseType() {
        return this.fBase;
    }

    void applyFacets1(XSFacets facets, short presentFacet) {
        try {
            this.applyFacets(facets, presentFacet, (short)0);
        }
        catch (InvalidDatatypeFacetException e) {
            throw new RuntimeException("internal error");
        }
        this.fIsImmutable = true;
    }

    void applyFacets2(XSFacets facets, short patternType) {
        try {
            this.applyFacets(facets, (short)16, patternType);
        }
        catch (InvalidDatatypeFacetException e) {
            throw new RuntimeException("internal error", e);
        }
        this.fIsImmutable = true;
    }

    void applyFacets(XSFacets facets, short presentFacet, short patternType) throws InvalidDatatypeFacetException {
        if (this.fIsImmutable) {
            return;
        }
        ValidatedInfo tempInfo = new ValidatedInfo();
        this.fFacetsDefined = 0;
        this.fFixedFacet = 0;
        int result = 0;
        short allowedFacet = this.fDVs[this.fValidationDV].getAllowedFacets();
        if ((presentFacet & 8) != 0) {
            if ((allowedFacet & 8) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"pattern", this.fTypeName});
            } else {
                Pattern regex = null;
                try {
                    regex = Pattern.compile(facets.pattern);
                }
                catch (Exception e) {
                    this.reportError("InvalidRegex", new Object[]{facets.pattern, e.getLocalizedMessage()});
                }
                if (regex != null) {
                    this.fPattern = new Vector();
                    this.fPattern.addElement(regex);
                    this.fPatternStr = new Vector();
                    this.fPatternStr.addElement(facets.pattern);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 8);
                }
            }
        }
        if ((presentFacet & 0x10) != 0) {
            if ((allowedFacet & 0x10) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"whiteSpace", this.fTypeName});
            } else {
                this.fWhiteSpace = facets.whiteSpace;
                this.fFacetsDefined = (short)(this.fFacetsDefined | 0x10);
            }
        }
        if ((presentFacet & 0x20) != 0) {
            if ((allowedFacet & 0x20) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"maxInclusive", this.fTypeName});
            } else {
                try {
                    this.fMaxInclusive = this.fBase.getActualValue(facets.maxInclusive, tempInfo);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x20);
                }
                catch (InvalidDatatypeValueException ide) {
                    this.reportError(ide.getKey(), ide.getArgs());
                    this.reportError("FacetValueFromBase", new Object[]{this.fTypeName, facets.maxInclusive, "maxInclusive", this.fBase.getName()});
                }
                if ((this.fBase.fFacetsDefined & 0x20) != 0 && (this.fBase.fFixedFacet & 0x20) != 0 && this.fDVs[this.fValidationDV].compare(this.fMaxInclusive, this.fBase.fMaxInclusive) != 0) {
                    this.reportError("FixedFacetValue", new Object[]{"maxInclusive", this.fMaxInclusive, this.fBase.fMaxInclusive, this.fTypeName});
                }
                try {
                    this.fBase.validate(tempInfo);
                }
                catch (InvalidDatatypeValueException ide) {
                    this.reportError(ide.getKey(), ide.getArgs());
                    this.reportError("FacetValueFromBase", new Object[]{this.fTypeName, facets.maxInclusive, "maxInclusive", this.fBase.getName()});
                }
            }
        }
        boolean needCheckBase = true;
        if ((presentFacet & 0x40) != 0) {
            if ((allowedFacet & 0x40) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"maxExclusive", this.fTypeName});
            } else {
                try {
                    this.fMaxExclusive = this.fBase.getActualValue(facets.maxExclusive, tempInfo);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x40);
                }
                catch (InvalidDatatypeValueException ide) {
                    this.reportError(ide.getKey(), ide.getArgs());
                    this.reportError("FacetValueFromBase", new Object[]{this.fTypeName, facets.maxExclusive, "maxExclusive", this.fBase.getName()});
                }
                if ((this.fBase.fFacetsDefined & 0x40) != 0) {
                    result = this.fDVs[this.fValidationDV].compare(this.fMaxExclusive, this.fBase.fMaxExclusive);
                    if ((this.fBase.fFixedFacet & 0x40) != 0 && result != 0) {
                        this.reportError("FixedFacetValue", new Object[]{"maxExclusive", facets.maxExclusive, this.fBase.fMaxExclusive, this.fTypeName});
                    }
                    if (result == 0) {
                        needCheckBase = false;
                    }
                }
                if (needCheckBase) {
                    try {
                        this.fBase.validate(tempInfo);
                    }
                    catch (InvalidDatatypeValueException ide) {
                        this.reportError(ide.getKey(), ide.getArgs());
                        this.reportError("FacetValueFromBase", new Object[]{this.fTypeName, facets.maxExclusive, "maxExclusive", this.fBase.getName()});
                    }
                } else if ((this.fBase.fFacetsDefined & 0x20) != 0 && this.fDVs[this.fValidationDV].compare(this.fMaxExclusive, this.fBase.fMaxInclusive) > 0) {
                    this.reportError("maxExclusive-valid-restriction.2", new Object[]{facets.maxExclusive, this.fBase.fMaxInclusive});
                }
            }
        }
        needCheckBase = true;
        if ((presentFacet & 0x80) != 0) {
            if ((allowedFacet & 0x80) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"minExclusive", this.fTypeName});
            } else {
                try {
                    this.fMinExclusive = this.fBase.getActualValue(facets.minExclusive, tempInfo);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x80);
                }
                catch (InvalidDatatypeValueException ide) {
                    this.reportError(ide.getKey(), ide.getArgs());
                    this.reportError("FacetValueFromBase", new Object[]{this.fTypeName, facets.minExclusive, "minExclusive", this.fBase.getName()});
                }
                if ((this.fBase.fFacetsDefined & 0x80) != 0) {
                    result = this.fDVs[this.fValidationDV].compare(this.fMinExclusive, this.fBase.fMinExclusive);
                    if ((this.fBase.fFixedFacet & 0x80) != 0 && result != 0) {
                        this.reportError("FixedFacetValue", new Object[]{"minExclusive", facets.minExclusive, this.fBase.fMinExclusive, this.fTypeName});
                    }
                    if (result == 0) {
                        needCheckBase = false;
                    }
                }
                if (needCheckBase) {
                    try {
                        this.fBase.validate(tempInfo);
                    }
                    catch (InvalidDatatypeValueException ide) {
                        this.reportError(ide.getKey(), ide.getArgs());
                        this.reportError("FacetValueFromBase", new Object[]{this.fTypeName, facets.minExclusive, "minExclusive", this.fBase.getName()});
                    }
                } else if ((this.fBase.fFacetsDefined & 0x100) != 0 && this.fDVs[this.fValidationDV].compare(this.fMinExclusive, this.fBase.fMinInclusive) < 0) {
                    this.reportError("minExclusive-valid-restriction.3", new Object[]{facets.minExclusive, this.fBase.fMinInclusive});
                }
            }
        }
        if ((presentFacet & 0x100) != 0) {
            if ((allowedFacet & 0x100) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"minInclusive", this.fTypeName});
            } else {
                try {
                    this.fMinInclusive = this.fBase.getActualValue(facets.minInclusive, tempInfo);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x100);
                }
                catch (InvalidDatatypeValueException ide) {
                    this.reportError(ide.getKey(), ide.getArgs());
                    this.reportError("FacetValueFromBase", new Object[]{this.fTypeName, facets.minInclusive, "minInclusive", this.fBase.getName()});
                }
                if ((this.fBase.fFacetsDefined & 0x100) != 0 && (this.fBase.fFixedFacet & 0x100) != 0 && this.fDVs[this.fValidationDV].compare(this.fMinInclusive, this.fBase.fMinInclusive) != 0) {
                    this.reportError("FixedFacetValue", new Object[]{"minInclusive", facets.minInclusive, this.fBase.fMinInclusive, this.fTypeName});
                }
                try {
                    this.fBase.validate(tempInfo);
                }
                catch (InvalidDatatypeValueException ide) {
                    this.reportError(ide.getKey(), ide.getArgs());
                    this.reportError("FacetValueFromBase", new Object[]{this.fTypeName, facets.minInclusive, "minInclusive", this.fBase.getName()});
                }
            }
        }
        if (patternType != 0) {
            this.fPatternType = patternType;
        }
        if (this.fFacetsDefined != 0) {
            if ((this.fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x20) != 0) {
                this.reportError("maxInclusive-maxExclusive", new Object[]{this.fMaxInclusive, this.fMaxExclusive, this.fTypeName});
            }
            if ((this.fFacetsDefined & 0x80) != 0 && (this.fFacetsDefined & 0x100) != 0) {
                this.reportError("minInclusive-minExclusive", new Object[]{this.fMinInclusive, this.fMinExclusive, this.fTypeName});
            }
            if ((this.fFacetsDefined & 0x20) != 0 && (this.fFacetsDefined & 0x100) != 0 && (result = this.fDVs[this.fValidationDV].compare(this.fMinInclusive, this.fMaxInclusive)) != -1 && result != 0) {
                this.reportError("minInclusive-less-than-equal-to-maxInclusive", new Object[]{this.fMinInclusive, this.fMaxInclusive, this.fTypeName});
            }
            if ((this.fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x80) != 0 && (result = this.fDVs[this.fValidationDV].compare(this.fMinExclusive, this.fMaxExclusive)) != -1 && result != 0) {
                this.reportError("minExclusive-less-than-equal-to-maxExclusive", new Object[]{this.fMinExclusive, this.fMaxExclusive, this.fTypeName});
            }
            if ((this.fFacetsDefined & 0x20) != 0 && (this.fFacetsDefined & 0x80) != 0 && this.fDVs[this.fValidationDV].compare(this.fMinExclusive, this.fMaxInclusive) != -1) {
                this.reportError("minExclusive-less-than-maxInclusive", new Object[]{this.fMinExclusive, this.fMaxInclusive, this.fTypeName});
            }
            if ((this.fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x100) != 0 && this.fDVs[this.fValidationDV].compare(this.fMinInclusive, this.fMaxExclusive) != -1) {
                this.reportError("minInclusive-less-than-maxExclusive", new Object[]{this.fMinInclusive, this.fMaxExclusive, this.fTypeName});
            }
            if ((this.fFacetsDefined & 0x10) != 0 && (this.fBase.fFacetsDefined & 0x10) != 0) {
                if ((this.fBase.fFixedFacet & 0x10) != 0 && this.fWhiteSpace != this.fBase.fWhiteSpace) {
                    this.reportError("FixedFacetValue", new Object[]{"whiteSpace", this.whiteSpaceValue(this.fWhiteSpace), this.whiteSpaceValue(this.fBase.fWhiteSpace), this.fTypeName});
                }
                if (this.fWhiteSpace == 0 && this.fBase.fWhiteSpace == 2) {
                    this.reportError("whiteSpace-valid-restriction.1", new Object[]{this.fTypeName, "preserve"});
                }
                if (this.fWhiteSpace == 1 && this.fBase.fWhiteSpace == 2) {
                    this.reportError("whiteSpace-valid-restriction.1", new Object[]{this.fTypeName, "replace"});
                }
                if (this.fWhiteSpace == 0 && this.fBase.fWhiteSpace == 1) {
                    this.reportError("whiteSpace-valid-restriction.2", new Object[]{this.fTypeName});
                }
            }
        }
        if ((this.fBase.fFacetsDefined & 8) != 0) {
            if ((this.fFacetsDefined & 8) == 0) {
                this.fFacetsDefined = (short)(this.fFacetsDefined | 8);
                this.fPattern = this.fBase.fPattern;
                this.fPatternStr = this.fBase.fPatternStr;
            } else {
                for (int i = this.fBase.fPattern.size() - 1; i >= 0; --i) {
                    this.fPattern.addElement(this.fBase.fPattern.elementAt(i));
                    this.fPatternStr.addElement(this.fBase.fPatternStr.elementAt(i));
                }
            }
        }
        if ((this.fFacetsDefined & 0x10) == 0 && (this.fBase.fFacetsDefined & 0x10) != 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x10);
            this.fWhiteSpace = this.fBase.fWhiteSpace;
        }
        if ((this.fBase.fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x40) == 0 && (this.fFacetsDefined & 0x20) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x40);
            this.fMaxExclusive = this.fBase.fMaxExclusive;
        }
        if ((this.fBase.fFacetsDefined & 0x20) != 0 && (this.fFacetsDefined & 0x40) == 0 && (this.fFacetsDefined & 0x20) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x20);
            this.fMaxInclusive = this.fBase.fMaxInclusive;
        }
        if ((this.fBase.fFacetsDefined & 0x80) != 0 && (this.fFacetsDefined & 0x80) == 0 && (this.fFacetsDefined & 0x100) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x80);
            this.fMinExclusive = this.fBase.fMinExclusive;
        }
        if ((this.fBase.fFacetsDefined & 0x100) != 0 && (this.fFacetsDefined & 0x80) == 0 && (this.fFacetsDefined & 0x100) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x100);
            this.fMinInclusive = this.fBase.fMinInclusive;
        }
        if (this.fPatternType == 0 && this.fBase.fPatternType != 0) {
            this.fPatternType = this.fBase.fPatternType;
        }
        this.fFixedFacet = (short)(this.fFixedFacet | this.fBase.fFixedFacet);
        this.calcFundamentalFacets();
    }

    @Override
    public Object validate(String content, ValidatedInfo validatedInfo) throws InvalidDatatypeValueException {
        if (validatedInfo == null) {
            validatedInfo = new ValidatedInfo();
        }
        Object ob = this.getActualValue(content, validatedInfo);
        this.validate(validatedInfo);
        return ob;
    }

    @Override
    public void validate(ValidatedInfo validatedInfo) throws InvalidDatatypeValueException {
        if (this.fFacetsDefined != 0 && this.fFacetsDefined != 16) {
            this.checkFacets(validatedInfo);
        }
    }

    private void checkFacets(ValidatedInfo validatedInfo) throws InvalidDatatypeValueException {
        int compare;
        Object ob = validatedInfo.actualValue;
        String content = validatedInfo.normalizedValue;
        if ((this.fFacetsDefined & 0x20) != 0 && (compare = this.fDVs[this.fValidationDV].compare(ob, this.fMaxInclusive)) != -1 && compare != 0) {
            throw new InvalidDatatypeValueException("cvc-maxInclusive-valid", new Object[]{content, this.fMaxInclusive, this.fTypeName});
        }
        if ((this.fFacetsDefined & 0x40) != 0 && (compare = this.fDVs[this.fValidationDV].compare(ob, this.fMaxExclusive)) != -1) {
            throw new InvalidDatatypeValueException("cvc-maxExclusive-valid", new Object[]{content, this.fMaxExclusive, this.fTypeName});
        }
        if ((this.fFacetsDefined & 0x100) != 0 && (compare = this.fDVs[this.fValidationDV].compare(ob, this.fMinInclusive)) != 1 && compare != 0) {
            throw new InvalidDatatypeValueException("cvc-minInclusive-valid", new Object[]{content, this.fMinInclusive, this.fTypeName});
        }
        if ((this.fFacetsDefined & 0x80) != 0 && (compare = this.fDVs[this.fValidationDV].compare(ob, this.fMinExclusive)) != 1) {
            throw new InvalidDatatypeValueException("cvc-minExclusive-valid", new Object[]{content, this.fMinExclusive, this.fTypeName});
        }
    }

    private Object getActualValue(Object content, ValidatedInfo validatedInfo) throws InvalidDatatypeValueException {
        Object avalue;
        String nvalue = this.normalize(content, this.fWhiteSpace);
        if ((this.fFacetsDefined & 8) != 0) {
            for (int idx = this.fPattern.size() - 1; idx >= 0; --idx) {
                Pattern regex = (Pattern)this.fPattern.elementAt(idx);
                if (regex.matcher(nvalue).matches()) continue;
                throw new InvalidDatatypeValueException("cvc-pattern-valid", new Object[]{content, this.fPatternStr.elementAt(idx), this.fTypeName});
            }
        }
        if (this.fPatternType != 0) {
            boolean seenErr = false;
            if (this.fPatternType == 1) {
                seenErr = !XercesXMLChar.isValidNmtoken(nvalue);
            } else if (this.fPatternType == 2) {
                seenErr = !XercesXMLChar.isValidName(nvalue);
            } else if (this.fPatternType == 3) {
                boolean bl = seenErr = !XercesXMLChar.isValidNCName(nvalue);
            }
            if (seenErr) {
                throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{nvalue, SPECIAL_PATTERN_STRING[this.fPatternType]});
            }
        }
        validatedInfo.normalizedValue = nvalue;
        validatedInfo.actualValue = avalue = this.fDVs[this.fValidationDV].getActualValue(nvalue);
        validatedInfo.actualValueType = this.fBuiltInKind;
        return avalue;
    }

    @Override
    public boolean isEqual(Object value1, Object value2) {
        if (value1 == null) {
            return false;
        }
        return value1.equals(value2);
    }

    public static String normalize(String content, short ws) {
        int len;
        int n = len = content == null ? 0 : content.length();
        if (len == 0 || ws == 0) {
            return content;
        }
        StringBuilder sb = new StringBuilder();
        if (ws == 1) {
            for (int i = 0; i < len; ++i) {
                char ch = content.charAt(i);
                if (ch != '\t' && ch != '\n' && ch != '\r') {
                    sb.append(ch);
                    continue;
                }
                sb.append(' ');
            }
        } else {
            boolean isLeading = true;
            for (int i = 0; i < len; ++i) {
                char ch = content.charAt(i);
                if (ch != '\t' && ch != '\n' && ch != '\r' && ch != ' ') {
                    sb.append(ch);
                    isLeading = false;
                    continue;
                }
                while (i < len - 1 && ((ch = content.charAt(i + 1)) == '\t' || ch == '\n' || ch == '\r' || ch == ' ')) {
                    ++i;
                }
                if (i >= len - 1 || isLeading) continue;
                sb.append(' ');
            }
        }
        return sb.toString();
    }

    protected String normalize(Object content, short ws) {
        if (content == null) {
            return null;
        }
        if ((this.fFacetsDefined & 8) == 0) {
            short norm_type = fDVNormalizeType[this.fValidationDV];
            if (norm_type == 0) {
                return content.toString();
            }
            if (norm_type == 1) {
                return XercesXMLChar.trim(content.toString());
            }
        }
        if (!(content instanceof StringBuilder)) {
            String strContent = content.toString();
            return XSSimpleTypeDecl.normalize(strContent, ws);
        }
        StringBuilder sb = (StringBuilder)content;
        int len = sb.length();
        if (len == 0) {
            return "";
        }
        if (ws == 0) {
            return sb.toString();
        }
        if (ws == 1) {
            for (int i = 0; i < len; ++i) {
                char ch = sb.charAt(i);
                if (ch != '\t' && ch != '\n' && ch != '\r') continue;
                sb.setCharAt(i, ' ');
            }
        } else {
            int j = 0;
            boolean isLeading = true;
            for (int i = 0; i < len; ++i) {
                char ch = sb.charAt(i);
                if (ch != '\t' && ch != '\n' && ch != '\r' && ch != ' ') {
                    sb.setCharAt(j++, ch);
                    isLeading = false;
                    continue;
                }
                while (i < len - 1 && ((ch = sb.charAt(i + 1)) == '\t' || ch == '\n' || ch == '\r' || ch == ' ')) {
                    ++i;
                }
                if (i >= len - 1 || isLeading) continue;
                sb.setCharAt(j++, ' ');
            }
            sb.setLength(j);
        }
        return sb.toString();
    }

    void reportError(String key, Object[] args) throws InvalidDatatypeFacetException {
        throw new InvalidDatatypeFacetException(key, args);
    }

    private String whiteSpaceValue(short ws) {
        return WS_FACET_STRING[ws];
    }

    private void calcFundamentalFacets() {
        this.setOrdered();
        this.setNumeric();
        this.setCardinality();
    }

    private void setOrdered() {
        this.fOrdered = this.fBase.fOrdered;
    }

    private void setNumeric() {
        this.fNumeric = this.fBase.fNumeric;
    }

    private void setCardinality() {
        this.fFinite = this.fBase.fFinite ? true : (!((this.fFacetsDefined & 0x100) == 0 && (this.fFacetsDefined & 0x80) == 0 || (this.fFacetsDefined & 0x20) == 0 && (this.fFacetsDefined & 0x40) == 0) ? false : false);
    }

    public String toString() {
        return this.fTargetNamespace + "," + this.fTypeName;
    }
}

