/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.cmd;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.jena.cmd.ArgProc;

public class CommandLineBase {
    private List<String> argList = new ArrayList<String>();
    boolean splitTerms = true;

    public CommandLineBase(String ... args) {
        this.setArgs(args);
    }

    public CommandLineBase() {
    }

    public void setArgs(String ... argv) {
        this.argList = this.processArgv(argv);
    }

    protected List<String> getArgList() {
        return this.argList;
    }

    protected String getArg(int i) {
        if (i < 0 || i >= this.argList.size()) {
            return null;
        }
        return this.argList.get(i);
    }

    protected void apply(ArgProc a) {
        a.startArgs();
        IntStream.range(0, this.argList.size()).forEach(i -> a.arg(this.argList.get(i), i));
        a.finishArgs();
    }

    private List<String> processArgv(String[] argv) {
        ArrayList<String> argList = new ArrayList<String>();
        boolean positional = false;
        if (null == argv) {
            return argList;
        }
        for (String anArgv : argv) {
            if (null == anArgv) continue;
            String argStr = anArgv;
            if (positional || !argStr.startsWith("-")) {
                argList.add(argStr);
                continue;
            }
            if (argStr.equals("-") || argStr.equals("--")) {
                positional = true;
                argList.add("--");
                continue;
            }
            if (!this.splitTerms) {
                argList.add(argStr);
                continue;
            }
            int j1 = argStr.indexOf(61);
            int j2 = argStr.indexOf(58);
            int j = -1;
            if (j1 > 0 && j2 > 0) {
                j = Math.min(j1, j2);
            } else {
                if (j1 > 0) {
                    j = j1;
                }
                if (j2 > 0) {
                    j = j2;
                }
            }
            if (j < 0) {
                argList.add(argStr);
                continue;
            }
            String argStr1 = argStr.substring(0, j);
            String argStr2 = argStr.substring(j + 1);
            argList.add(argStr1);
            argList.add(argStr2);
        }
        return argList;
    }
}

