/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.ref;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.TableFactory;
import org.apache.jena.sparql.algebra.op.OpDatasetNames;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.table.TableEmpty;
import org.apache.jena.sparql.algebra.table.TableN;
import org.apache.jena.sparql.algebra.table.TableUnit;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingRoot;
import org.apache.jena.sparql.engine.iterator.QueryIterConcat;
import org.apache.jena.sparql.engine.iterator.QueryIterDistinguishedVars;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.engine.iterator.QueryIterRoot;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.engine.ref.Evaluator;
import org.apache.jena.sparql.engine.ref.EvaluatorDispatch;
import org.apache.jena.sparql.engine.ref.EvaluatorFactory;

public class RefEval {
    public static Table eval(Evaluator evaluator, Op op) {
        EvaluatorDispatch ev = new EvaluatorDispatch(evaluator);
        op.visit(ev);
        Table table = ev.getResult();
        return table;
    }

    static Table evalDS(OpDatasetNames opDSN, Evaluator evaluator) {
        Node graphNode = opDSN.getGraphNode();
        if (graphNode.isURI()) {
            if (evaluator.getExecContext().getDataset().containsGraph(graphNode)) {
                return new TableUnit();
            }
            return new TableEmpty();
        }
        if (!Var.isVar(graphNode)) {
            throw new ARQInternalErrorException("OpDatasetNames: Not a URI or variable: " + String.valueOf(graphNode));
        }
        DatasetGraph dsg = evaluator.getExecContext().getDataset();
        Iterator<Node> iter = dsg.listGraphNodes();
        ArrayList<Binding> list = new ArrayList<Binding>();
        while (iter.hasNext()) {
            Node gn = iter.next();
            Binding b = BindingFactory.binding(Var.alloc(graphNode), gn);
            list.add(b);
        }
        QueryIterator qIter = QueryIterPlainWrapper.create(list.iterator(), evaluator.getExecContext());
        return TableFactory.create(qIter);
    }

    static Table evalGraph(OpGraph opGraph, Evaluator evaluator) {
        ExecutionContext execCxt = evaluator.getExecContext();
        if (!Var.isVar(opGraph.getNode())) {
            Node graphNode;
            DatasetGraph dsg = execCxt.getDataset();
            if (!dsg.containsGraph(graphNode = opGraph.getNode())) {
                return new TableEmpty();
            }
            Graph graph = execCxt.getDataset().getGraph(opGraph.getNode());
            if (graph == null) {
                throw new InternalErrorException("Graph was present, now it's not");
            }
            ExecutionContext execCxt2 = ExecutionContext.copyChangeActiveGraph(execCxt, graph);
            Evaluator e2 = EvaluatorFactory.create(execCxt2);
            return RefEval.eval(e2, opGraph.getSubOp());
        }
        Var gVar = Var.alloc(opGraph.getNode());
        Table current = null;
        Iterator<Node> iter = execCxt.getDataset().listGraphNodes();
        while (iter.hasNext()) {
            Node gn = iter.next();
            Graph graph = execCxt.getDataset().getGraph(gn);
            ExecutionContext execCxt2 = ExecutionContext.copyChangeActiveGraph(execCxt, graph);
            Evaluator e2 = EvaluatorFactory.create(execCxt2);
            Table tableVarURI = TableFactory.create(gVar, gn);
            Table patternTable = RefEval.eval(e2, opGraph.getSubOp());
            Table stepResult = evaluator.join(patternTable, tableVarURI);
            if (current == null) {
                current = stepResult;
                continue;
            }
            current = evaluator.union(current, stepResult);
        }
        if (current == null) {
            return new TableEmpty();
        }
        return current;
    }

    static Table evalQuadPattern(OpQuadPattern opQuad, Evaluator evaluator) {
        if (opQuad.isEmpty()) {
            return TableFactory.createUnit();
        }
        ExecutionContext cxt = evaluator.getExecContext();
        DatasetGraph ds = cxt.getDataset();
        BasicPattern pattern = opQuad.getBasicPattern();
        if (!opQuad.getGraphNode().isVariable()) {
            if (!opQuad.getGraphNode().isURI()) {
                throw new ARQInternalErrorException("Not a URI or variable: " + String.valueOf(opQuad.getGraphNode()));
            }
            Graph g = null;
            g = opQuad.isDefaultGraph() ? ds.getDefaultGraph() : ds.getGraph(opQuad.getGraphNode());
            if (g == null) {
                return new TableEmpty();
            }
            ExecutionContext cxt2 = ExecutionContext.copyChangeActiveGraph(cxt, g);
            QueryIterator qIter = RefEval.executeBGP(pattern, QueryIterRoot.create(cxt2), cxt2);
            return TableFactory.create(qIter);
        }
        Var gVar = Var.alloc(opQuad.getGraphNode());
        QueryIterConcat concat2 = new QueryIterConcat(cxt);
        Iterator<Node> graphNodes = cxt.getDataset().listGraphNodes();
        while (graphNodes.hasNext()) {
            Node gn = graphNodes.next();
            Graph g = cxt.getDataset().getGraph(gn);
            Binding b = BindingFactory.binding(BindingRoot.create(), gVar, gn);
            ExecutionContext cxt2 = ExecutionContext.copyChangeActiveGraph(cxt, g);
            Table t1 = TableFactory.create(gVar, gn);
            QueryIterator qIter = RefEval.executeBGP(pattern, QueryIterRoot.create(cxt2), cxt2);
            Table t2 = TableFactory.create(qIter);
            Table t3 = evaluator.join(t1, t2);
            concat2.add(t3.iterator(cxt2));
        }
        return TableFactory.create(concat2);
    }

    private static QueryIterator executeBGP(BasicPattern pattern, QueryIterator input, ExecutionContext execCxt) {
        if (pattern.isEmpty()) {
            return input;
        }
        boolean hideBNodeVars = execCxt.getContext().isTrue(ARQ.hideNonDistiguishedVariables);
        QueryIterator qIter = QC.executeDirect(pattern, input, execCxt);
        if (hideBNodeVars) {
            qIter = new QueryIterDistinguishedVars(qIter, execCxt);
        }
        return qIter;
    }

    static Table semiJoin(Table left, Table right) {
        return RefEval.halfJoin(HALF_JOIN.SEMI, left, right);
    }

    static Table antiJoin(Table left, Table right) {
        return RefEval.halfJoin(HALF_JOIN.ANTI, left, right);
    }

    static Table halfJoin(HALF_JOIN halfJoin, Table left, Table right) {
        if (left.isEmpty()) {
            left.close();
            return TableFactory.createEmpty();
        }
        TableN result = new TableN();
        left.rows().forEachRemaining(bindingLeft -> {
            Binding b;
            boolean hasMatch = false;
            Iterator<Binding> iterRight = right.rows();
            while (iterRight.hasNext()) {
                Binding bindingRight = iterRight.next();
                boolean matches = Algebra.compatible(bindingLeft, bindingRight);
                if (!matches) continue;
                hasMatch = true;
                Binding b2 = halfJoin.onOneMatch((Binding)bindingLeft);
                if (b2 == null) break;
                result.addBinding(b2);
                break;
            }
            if (!hasMatch && (b = halfJoin.onNoMatches((Binding)bindingLeft)) != null) {
                result.addBinding(b);
            }
        });
        right.close();
        return result;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum HALF_JOIN {
        SEMI{

            @Override
            public Binding onOneMatch(Binding bindingLeft) {
                return bindingLeft;
            }

            @Override
            public Binding onNoMatches(Binding bindingLeft) {
                return null;
            }
        }
        ,
        ANTI{

            @Override
            public Binding onOneMatch(Binding bindingLeft) {
                return null;
            }

            @Override
            public Binding onNoMatches(Binding bindingLeft) {
                return null;
            }
        };


        public abstract Binding onOneMatch(Binding var1);

        public abstract Binding onNoMatches(Binding var1);
    }
}

