/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.function.Supplier;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.system.Txn;

public interface Transactional {
    default public void begin() {
        this.begin(TxnType.READ_PROMOTE);
    }

    public void begin(TxnType var1);

    default public void begin(ReadWrite readWrite) {
        this.begin(TxnType.convert(readWrite));
    }

    default public boolean promote() {
        if (this.transactionMode() == ReadWrite.WRITE) {
            return true;
        }
        TxnType txnType = this.transactionType();
        if (txnType == null) {
            throw new JenaTransactionException("txnType");
        }
        switch (txnType) {
            case WRITE: {
                return true;
            }
            case READ: {
                return false;
            }
            case READ_PROMOTE: {
                return this.promote(Promote.ISOLATED);
            }
            case READ_COMMITTED_PROMOTE: {
                return this.promote(Promote.READ_COMMITTED);
            }
        }
        throw new JenaTransactionException("Can't determine promote '" + String.valueOf((Object)txnType) + "'transaction");
    }

    public boolean promote(Promote var1);

    public void commit();

    public void abort();

    public void end();

    public ReadWrite transactionMode();

    public TxnType transactionType();

    public boolean isInTransaction();

    default public void exec(TxnType txnType, Runnable action) {
        Txn.exec(this, txnType, action);
    }

    default public <T> T calc(TxnType txnType, Supplier<T> action) {
        return Txn.calc(this, txnType, action);
    }

    default public void execute(Runnable r) {
        Txn.execute(this, r);
    }

    default public <X> X calculate(Supplier<X> r) {
        return Txn.calculate(this, r);
    }

    default public <T extends Transactional> void executeRead(Runnable r) {
        Txn.executeRead(this, r);
    }

    default public <X> X calculateRead(Supplier<X> r) {
        return Txn.calculateRead(this, r);
    }

    default public void executeWrite(Runnable r) {
        Txn.executeWrite(this, r);
    }

    default public <X> X calculateWrite(Supplier<X> r) {
        return Txn.calculateWrite(this, r);
    }

    public static enum Promote {
        ISOLATED,
        READ_COMMITTED;

    }
}

