/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.optimize;

import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.expr.E_Exists;
import org.apache.jena.sparql.expr.E_NotExists;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunctionOp;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransformCopy;

public class ExprTransformApplyTransform
extends ExprTransformCopy {
    private final Transform transform;
    private OpVisitor beforeVisitor;
    private OpVisitor afterVisitor;

    public ExprTransformApplyTransform(Transform transform) {
        this(transform, null, null);
    }

    public ExprTransformApplyTransform(Transform transform, OpVisitor beforeVisitor, OpVisitor afterVisitor) {
        this.transform = transform;
        this.beforeVisitor = beforeVisitor;
        this.afterVisitor = afterVisitor;
    }

    @Override
    public Expr transform(ExprFunctionOp funcOp, ExprList args, Op opArg) {
        Op opArg2 = Transformer.transform(this.transform, opArg, this.beforeVisitor, this.afterVisitor);
        if (opArg2 == opArg) {
            return super.transform(funcOp, args, opArg);
        }
        if (funcOp instanceof E_Exists) {
            return new E_Exists(opArg2);
        }
        if (funcOp instanceof E_NotExists) {
            return new E_NotExists(opArg2);
        }
        throw new ARQInternalErrorException("Unrecognized ExprFunctionOp: \n" + String.valueOf(funcOp));
    }
}

