/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.expressions;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.shex.expressions.DatatypeConstraint;
import org.apache.jena.shex.expressions.NodeConstraintComponent;
import org.apache.jena.shex.expressions.NodeKindConstraint;
import org.apache.jena.shex.expressions.Satisfies;
import org.apache.jena.shex.expressions.ShexPrintable;
import org.apache.jena.shex.expressions.ValueConstraint;
import org.apache.jena.shex.sys.ReportItem;
import org.apache.jena.shex.sys.ValidationContext;

public class NodeConstraint
implements Satisfies,
ShexPrintable {
    private List<NodeConstraintComponent> constraints = new ArrayList<NodeConstraintComponent>();

    public NodeConstraint(List<NodeConstraintComponent> constraints) {
        this.constraints = List.copyOf(constraints);
    }

    public List<NodeConstraintComponent> components() {
        return this.constraints;
    }

    @Override
    public boolean satisfies(ValidationContext vCxt, Node data) {
        for (NodeConstraintComponent ncc : this.constraints) {
            ReportItem item = ncc.nodeSatisfies(vCxt, data);
            if (item == null) continue;
            vCxt.reportEntry(item);
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.constraints == null ? 0 : this.constraints.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeConstraint other = (NodeConstraint)obj;
        return !(this.constraints == null ? other.constraints != null : !this.constraints.equals(other.constraints));
    }

    public String toString() {
        return "NodeConstraint [constraints=" + String.valueOf(this.constraints) + "]";
    }

    static class NodeConstraintBuilder {
        NodeKindConstraint nodeKind;
        DatatypeConstraint datatype = null;
        List<NodeConstraint> facets = new ArrayList<NodeConstraint>();
        ValueConstraint values;

        NodeConstraintBuilder() {
        }
    }
}

