/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.langtag;

import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.langtag.InternalLangTag;
import org.apache.jena.langtag.LangTag;

public final class LangTagRFC5646
implements LangTag {
    private final String langTagString;
    private final boolean isGrandfathered;
    private final boolean isPrivateUseLanguage;
    private final int language0;
    private final int language1;
    private final int script0;
    private final int script1;
    private final int region0;
    private final int region1;
    private final int variant0;
    private final int variant1;
    private final int extension0;
    private final int extension1;
    private final int privateuse0;
    private final int privateuse1;
    private static Set<String> regular = Set.of("art-lojban", "cel-gaulish", "no-bok", "no-nyn", "zh-guoyu", "zh-hakka", "zh-min", "zh-min-nan", "zh-xiang");
    private static Set<String> irregular = Set.of("en-GB-oed", "i-ami", "i-bnn", "i-default", "i-enochian", "i-hak", "i-klingon", "i-lux", "i-mingo", "i-navajo", "i-pwn", "i-tao", "i-tay", "i-tsu", "sgn-BE-FR", "sgn-BE-NL", "sgn-CH-DE");
    private static Set<String> irregular_i = Set.of("i-ami", "i-bnn", "i-default", "i-enochian", "i-hak", "i-klingon", "i-lux", "i-mingo", "i-navajo", "i-pwn", "i-tao", "i-tay", "i-tsu");
    private static Set<String> grandfathered = new HashSet<String>(2 * (regular.size() + irregular.size()));

    public static LangTag create(String string) {
        LangTagRFC5646 langtag = LangTagRFC5646.parser(string);
        return langtag;
    }

    @Override
    public String getLanguage() {
        String x = LangTagRFC5646.getSubTag("Language", this.langTagString, this.language0, this.language1, CaseRule.LOWER);
        if (!this.isGrandfathered) {
            return x;
        }
        return switch (x) {
            case "sgn-be-fr" -> "sgn-BE-FR";
            case "sgn-be-nl" -> "sgn-BE-NL";
            case "sgn-ch-de" -> "sgn-CH-DE";
            default -> x;
        };
    }

    @Override
    public String getScript() {
        return LangTagRFC5646.getSubTag("Script", this.langTagString, this.script0, this.script1, CaseRule.TITLE);
    }

    @Override
    public String getRegion() {
        return LangTagRFC5646.getSubTag("Region", this.langTagString, this.region0, this.region1, CaseRule.UPPER);
    }

    @Override
    public String getVariant() {
        return LangTagRFC5646.getSubTag("Variant", this.langTagString, this.variant0, this.variant1, CaseRule.LOWER);
    }

    @Override
    public String getExtension() {
        return LangTagRFC5646.getSubTag("Extension", this.langTagString, this.extension0, this.extension1, CaseRule.LOWER);
    }

    @Override
    public String getPrivateUse() {
        return LangTagRFC5646.getSubTag("Private", this.langTagString, this.privateuse0, this.privateuse1, CaseRule.LOWER);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.langTagString, this.language0, this.language1, this.script0, this.script1, this.variant0, this.variant1, this.extension0, this.extension1, this.privateuse0, this.privateuse1, this.isGrandfathered, this.isPrivateUseLanguage);
    }

    @Override
    public boolean equals(Object obj) {
        boolean sameParsePoints;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LangTagRFC5646)) {
            return false;
        }
        LangTagRFC5646 other = (LangTagRFC5646)obj;
        boolean bl = sameParsePoints = this.extension0 == other.extension0 && this.extension1 == other.extension1 && this.isGrandfathered == other.isGrandfathered && this.isPrivateUseLanguage == other.isPrivateUseLanguage && this.language0 == other.language0 && this.language1 == other.language1 && this.privateuse0 == other.privateuse0 && this.privateuse1 == other.privateuse1 && this.region0 == other.region0 && this.region1 == other.region1 && this.script0 == other.script0 && this.script1 == other.script1 && this.variant0 == other.variant0 && this.variant1 == other.variant1;
        if (!sameParsePoints) {
            return false;
        }
        return Objects.equals(this.langTagString, other.langTagString);
    }

    @Override
    public String toString() {
        return this.langTagString;
    }

    @Override
    public String str() {
        if (this.isPrivateUseLanguage) {
            return InternalLangTag.lowercase(this.langTagString);
        }
        String x = LangTagRFC5646.irregularFormat(this.langTagString);
        if (x != null) {
            return x;
        }
        StringBuffer sb = new StringBuffer();
        this.add(sb, this.getLanguage());
        this.add(sb, this.getScript());
        this.add(sb, this.getRegion());
        this.add(sb, this.getVariant());
        this.add(sb, this.getExtension());
        this.add(sb, this.getPrivateUse());
        return sb.toString();
    }

    private static String irregularFormat(String langTagString) {
        String lcLangTagStr;
        if (InternalLangTag.caseInsensitivePrefix(langTagString, "sgn-")) {
            if (langTagString.equalsIgnoreCase("sgn-BE-FR")) {
                return "sgn-BE-FR";
            }
            if (langTagString.equalsIgnoreCase("sgn-BE-NL")) {
                return "sgn-BE-NL";
            }
            if (langTagString.equalsIgnoreCase("sgn-CH-DE")) {
                return "sgn-CH-DE";
            }
        }
        if ((langTagString.startsWith("i-") || langTagString.startsWith("I-")) && irregular_i.contains(lcLangTagStr = InternalLangTag.lowercase(langTagString))) {
            return lcLangTagStr;
        }
        return null;
    }

    private void add(StringBuffer sb, String subtag) {
        if (subtag == null) {
            return;
        }
        if (!sb.isEmpty()) {
            sb.append('-');
        }
        sb.append(subtag);
    }

    private static String getSubTag(String label, String string, int start, int finish, CaseRule format) {
        if (start == -1) {
            return null;
        }
        if (finish == -1) {
            throw new InternalError(InternalLangTag.titlecase(label) + " start is set but not subtag end: " + string);
        }
        if (start >= finish) {
            throw new InternalError(InternalLangTag.titlecase(label) + " start index is after " + InternalLangTag.lowercase(label) + " end index: " + string);
        }
        String x = string.substring(start, finish);
        return switch (format) {
            default -> throw new IncompatibleClassChangeError();
            case CaseRule.TITLE -> InternalLangTag.titlecase(x);
            case CaseRule.LOWER -> InternalLangTag.lowercase(x);
            case CaseRule.UPPER -> InternalLangTag.uppercase(x);
        };
    }

    private static LangTagRFC5646 parser(String string) {
        LangTagRFC5646 langtag = new Builder().parse(string).build();
        return langtag;
    }

    static void parse(Builder builder, String string) {
        builder.langTagString = string;
        int N = string.length();
        if (N == 0) {
            InternalLangTag.error("Empty string", new Object[0]);
        }
        if (LangTagRFC5646.grandfathered(string)) {
            builder.language0 = 0;
            builder.language1 = N;
            builder.isGrandfathered = true;
            if (string.equalsIgnoreCase("en-GB-oed")) {
                builder.language0 = 0;
                builder.language1 = 2;
                builder.region0 = 3;
                builder.region1 = 5;
                builder.variant0 = 6;
                builder.variant1 = N;
            }
            return;
        }
        int idx = 0;
        int idx2 = LangTagRFC5646.segmentNextFinish(string, N, idx);
        int segLen = LangTagRFC5646.segmentLength(N, idx, idx2);
        if (segLen == 1) {
            if (string.startsWith("x-") || string.startsWith("X-")) {
                builder.isPrivateUseLanguage = true;
                int idxPrivateUseStart = 0;
                int idxPrivateUseEnd = LangTagRFC5646.maybeSubtags(string, N, idxPrivateUseStart + segLen, CharRange.ALPHANUM, 1, 8);
                builder.privateuse0 = idxPrivateUseStart;
                builder.privateuse1 = idxPrivateUseEnd;
                if (builder.privateuse1 < N) {
                    InternalLangTag.error("Trailing characters in private langtag: '%s'", string.substring(builder.privateuse1));
                }
                return;
            }
            InternalLangTag.error("Language part is 1 character: it must be 2-3 characters (4-8 reserved for future use), \"x-\", or a recognized grandfathered tag", new Object[0]);
        }
        if (segLen > 8) {
            InternalLangTag.error("Language too long (2-3 characters, 4-8 reserved for future use)", new Object[0]);
        }
        if (idx2 < 0) {
            builder.language0 = 0;
            builder.language1 = N;
            InternalLangTag.checkAlpha(string, N, builder.language0, builder.language1);
            return;
        }
        if (idx == idx2) {
            InternalLangTag.error("Can not find the language subtag: '%s'", string);
        }
        builder.language0 = idx;
        if (segLen == 2 || segLen == 3) {
            int extStart = idx + segLen;
            InternalLangTag.checkAlpha(string, N, builder.language0, extStart);
            int extEnd = LangTagRFC5646.maybeSubtags(string, N, extStart, CharRange.ALPHA, 3, 3);
            if (extEnd > extStart) {
                idx2 = extEnd;
                InternalLangTag.checkAlphaMinus(string, N, extStart, builder.language1);
            }
        } else if (segLen >= 4 && segLen <= 8) {
            InternalLangTag.checkAlpha(string, N, builder.language0, idx2);
        } else {
            InternalLangTag.error("Language too long (2-3 characters, 4-8 reserved for future use)", new Object[0]);
        }
        builder.language1 = idx2;
        LangTagRFC5646.noteSegment("language", string, builder.language0, builder.language1);
        idx = LangTagRFC5646.segmentNextStart(N, idx, idx2);
        idx2 = LangTagRFC5646.segmentNextFinish(string, N, idx);
        segLen = LangTagRFC5646.segmentLength(N, idx, idx2);
        if (segLen == 4 && InternalLangTag.isAlpha(string.charAt(idx))) {
            int start = idx;
            int finish = idx + segLen;
            builder.script0 = idx;
            builder.script1 = idx + segLen;
            InternalLangTag.checkAlpha(string, N, builder.script0, builder.script1);
            LangTagRFC5646.noteSegment("script", string, builder.script0, builder.script1);
            idx = LangTagRFC5646.segmentNextStart(N, idx, idx2);
            idx2 = LangTagRFC5646.segmentNextFinish(string, N, idx);
            segLen = LangTagRFC5646.segmentLength(N, idx, idx2);
        }
        if (segLen == 2 || segLen == 3) {
            builder.region0 = idx;
            builder.region1 = idx + segLen;
            if (segLen == 2) {
                InternalLangTag.checkAlpha(string, N, builder.region0, builder.region1);
            } else {
                InternalLangTag.checkDigits(string, N, builder.region0, builder.region1);
            }
            LangTagRFC5646.noteSegment("region", string, builder.region0, builder.region1);
            idx = LangTagRFC5646.segmentNextStart(N, idx, idx2);
            idx2 = LangTagRFC5646.segmentNextFinish(string, N, idx);
            segLen = LangTagRFC5646.segmentLength(N, idx, idx2);
        }
        while (true) {
            if (segLen >= 5 && segLen <= 8) {
                if (builder.variant0 == -1) {
                    builder.variant0 = idx;
                }
                builder.variant1 = idx + segLen;
                InternalLangTag.checkAlphaNum(string, N, idx, builder.variant1);
                LangTagRFC5646.noteSegment("variant", string, builder.variant0, builder.variant1);
                idx = LangTagRFC5646.segmentNextStart(N, idx, idx2);
                idx2 = LangTagRFC5646.segmentNextFinish(string, N, idx);
                segLen = LangTagRFC5646.segmentLength(N, idx, idx2);
                continue;
            }
            if (segLen != 4) break;
            char ch = string.charAt(idx);
            if (ch >= '0' || ch <= '9') {
                if (builder.variant0 == -1) {
                    builder.variant0 = idx;
                }
                builder.variant1 = idx + segLen;
                InternalLangTag.checkAlphaNum(string, N, idx, builder.variant1);
                LangTagRFC5646.noteSegment("variant", string, builder.variant0, builder.variant1);
            }
            idx = LangTagRFC5646.segmentNextStart(N, idx, idx2);
            idx2 = LangTagRFC5646.segmentNextFinish(string, N, idx);
            segLen = LangTagRFC5646.segmentLength(N, idx, idx2);
        }
        boolean inPrivateUseSubtag = false;
        HashSet<Character> extSingletons = null;
        new HashSet();
        while (segLen == 1) {
            int idxEndExtra;
            int idxExtStart;
            char singleton = string.charAt(idx);
            if (singleton == 'x' || singleton == 'X') {
                inPrivateUseSubtag = true;
                break;
            }
            if (extSingletons == null) {
                extSingletons = new HashSet<Character>();
                extSingletons.add(Character.valueOf(singleton));
            } else {
                boolean newEntry = extSingletons.add(Character.valueOf(singleton));
                if (!newEntry) {
                    InternalLangTag.error("Duplicate extension singleton: '" + singleton + "'", new Object[0]);
                }
            }
            if (builder.extension0 == -1) {
                builder.extension0 = idx;
            }
            if ((idxExtStart = idx + segLen) == (idxEndExtra = LangTagRFC5646.maybeSubtags(string, N, idxExtStart, CharRange.ALPHANUM, 2, 8))) {
                InternalLangTag.error("Ill-formed extension", new Object[0]);
            }
            if (idxEndExtra > idxExtStart) {
                idx2 = idxEndExtra;
            }
            builder.extension1 = idx2;
            InternalLangTag.checkAlphaNumMinus(string, N, builder.extension0, builder.extension1);
            LangTagRFC5646.noteSegment("extension", string, builder.extension0, builder.extension1);
            segLen = LangTagRFC5646.segmentLength(N, idx = LangTagRFC5646.segmentNextStart(N, idx, idx2), idx2 = LangTagRFC5646.segmentNextFinish(string, N, idx));
            if (segLen != 0) continue;
            InternalLangTag.error("Ill-formed extension. Trailing dash.", new Object[0]);
        }
        if (inPrivateUseSubtag) {
            builder.privateuse0 = idx;
            int idxPrivateUseStart = idx + segLen;
            int idxPrivateUseEnd = LangTagRFC5646.maybeSubtags(string, N, idxPrivateUseStart, CharRange.ALPHANUM, 1, 8);
            if (idxPrivateUseStart == idxPrivateUseEnd) {
                InternalLangTag.error("Ill-formed private use component", new Object[0]);
            }
            if (idxPrivateUseEnd > idxPrivateUseStart) {
                idx2 = idxPrivateUseEnd;
            }
            builder.privateuse1 = idx2;
            InternalLangTag.checkAlphaNumMinus(string, N, builder.privateuse0, builder.privateuse1);
            LangTagRFC5646.noteSegment("private use", string, builder.privateuse0, builder.privateuse1);
            idx = LangTagRFC5646.segmentNextStart(N, idx, idx2);
            idx2 = LangTagRFC5646.segmentNextFinish(string, N, idx);
            segLen = LangTagRFC5646.segmentLength(N, idx, idx2);
            if (segLen == 0) {
                InternalLangTag.error("Ill-formed private use subtag. Trailing dash.", new Object[0]);
            }
        }
        if (idx != -1 && idx < N) {
            InternalLangTag.error("Trailing characters: '%s'", string.substring(idx));
        }
        if (idx2 >= 0) {
            InternalLangTag.error("Bad string: '%s'", string);
        }
    }

    private LangTagRFC5646(String string, int language0, int language1, int script0, int script1, int region0, int region1, int variant0, int variant1, int extension0, int extension1, int privateuse0, int privateuse1, boolean isGrandfathered, boolean isPrivateUseLanguage) {
        this.langTagString = string;
        this.isGrandfathered = isGrandfathered;
        this.isPrivateUseLanguage = isPrivateUseLanguage;
        this.language0 = language0;
        this.language1 = language1;
        this.script0 = script0;
        this.script1 = script1;
        this.region0 = region0;
        this.region1 = region1;
        this.variant0 = variant0;
        this.variant1 = variant1;
        this.extension0 = extension0;
        this.extension1 = extension1;
        this.privateuse0 = privateuse0;
        this.privateuse1 = privateuse1;
    }

    private static int maybeSubtags(String string, int N, int idxStart, CharRange charRange, int min, int max) {
        int x1;
        char ch;
        boolean numExt = false;
        boolean count = false;
        int x = idxStart;
        while (x >= 0 && x < N && (ch = string.charAt(x)) == '-' && (x1 = LangTagRFC5646.maybeOneSubtag(string, N, x + 1, charRange, min, max)) > 0) {
            if (x1 == N) {
                x = N;
                break;
            }
            x = x1;
        }
        return x;
    }

    private static int maybeOneSubtag(String string, int N, int idxStart, CharRange charRange, int min, int max) {
        boolean valid;
        int idx = idxStart;
        if (idx >= N) {
            return -1;
        }
        int idx2 = LangTagRFC5646.segmentNextFinish(string, N, idx);
        int segLen = LangTagRFC5646.segmentLength(N, idx, idx2);
        if (segLen == 0) {
            InternalLangTag.error("Bad builder. Found '--'", new Object[0]);
        }
        if (segLen < min || segLen > max) {
            return -1;
        }
        switch (charRange) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ALPHA: {
                boolean bl = InternalLangTag.isAlpha(string, idxStart, idxStart + segLen);
                break;
            }
            case ALPHANUM: {
                boolean bl = valid = InternalLangTag.isAlphaNum(string, idxStart, idxStart + segLen);
            }
        }
        if (!valid) {
            return -1;
        }
        return idxStart + segLen;
    }

    private static String getSegment(String string, int x0, int x1) {
        if (x0 < 0 && x1 < 0) {
            return null;
        }
        if (x0 < 0 || x1 < 0) {
            InternalLangTag.error("Segment one undef index", new Object[0]);
            return null;
        }
        return string.substring(x0, x1);
    }

    private static int segmentLength(int N, int idx, int idx2) {
        if (idx < 0) {
            return -1;
        }
        if (idx2 < 0) {
            return N - idx;
        }
        return idx2 - idx;
    }

    private static int segmentNextStart(int N, int idx, int idx2) {
        if (idx2 == -1) {
            return -1;
        }
        idx = idx2;
        return ++idx;
    }

    private static void noteSegment(String label, String string, int idx, int idx2) {
    }

    private static int segmentNextFinish(String x, int N, int idx) {
        if (idx == -1) {
            return -1;
        }
        if (idx == N) {
            return -1;
        }
        while (idx < N) {
            char ch = x.charAt(idx);
            if (ch == '-') {
                if (idx == N - 1) {
                    InternalLangTag.error("Language tag string ends in '-'", new Object[0]);
                }
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    private static boolean grandfathered(String s) {
        return grandfathered.contains(s = s.toLowerCase(Locale.ROOT)) || regular.contains(s);
    }

    static {
        for (String s : irregular) {
            grandfathered.add(InternalLangTag.lowercase(s));
        }
        for (String s : regular) {
            grandfathered.add(InternalLangTag.lowercase(s));
        }
    }

    private static enum CaseRule {
        TITLE,
        LOWER,
        UPPER;

    }

    private static class Builder {
        String langTagString = null;
        boolean isGrandfathered = false;
        boolean isPrivateUseLanguage = false;
        int language0 = -1;
        int language1 = -1;
        int script0 = -1;
        int script1 = -1;
        int region0 = -1;
        int region1 = -1;
        int variant0 = -1;
        int variant1 = -1;
        int extension0 = -1;
        int extension1 = -1;
        int privateuse0 = -1;
        int privateuse1 = -1;

        Builder() {
        }

        private Builder parse(String string) {
            Builder builder = this;
            LangTagRFC5646.parse(builder, string);
            return this;
        }

        private LangTagRFC5646 build() {
            return new LangTagRFC5646(this.langTagString, this.language0, this.language1, this.script0, this.script1, this.region0, this.region1, this.variant0, this.variant1, this.extension0, this.extension1, this.privateuse0, this.privateuse1, this.isGrandfathered, this.isPrivateUseLanguage);
        }
    }

    private static enum CharRange {
        ALPHA,
        ALPHANUM;

    }
}

