/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.assemblers;

import java.util.Map;
import java.util.Objects;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.assembler.assemblers.ReasonerFactoryAssembler;
import org.apache.jena.assembler.exceptions.AssemblerException;
import org.apache.jena.assembler.exceptions.ReasonerClashException;
import org.apache.jena.ontapi.OntSpecification;
import org.apache.jena.ontapi.assemblers.OA;
import org.apache.jena.ontapi.common.OntPersonalities;
import org.apache.jena.ontapi.common.OntPersonality;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.reasoner.ReasonerFactory;

public class OntSpecificationAssembler
extends AssemblerBase {
    public Object open(Assembler a, Resource root, Mode mode) {
        OntPersonality p;
        this.checkType(root, OA.OntSpecification);
        String specificationName = OntSpecificationAssembler.getLiteralString(root, OA.specificationName);
        String personalityName = OntSpecificationAssembler.getLiteralString(root, OA.personalityName);
        if (specificationName != null) {
            if (personalityName != null) {
                throw new AssemblerException(root, "Both personality and specification are specified. There should be only one.");
            }
            OntSpecification s = Components.BUILTIN_SPECIFICATIONS.get(specificationName);
            if (s == null) {
                throw new AssemblerException(root, "Unknown specification: '" + specificationName + "'. Must be one of the following:\n" + String.join((CharSequence)"\n", Components.BUILTIN_SPECIFICATIONS.keySet()));
            }
            return s;
        }
        if (personalityName != null) {
            p = Components.BUILTIN_PERSONALITIES.get(personalityName);
            if (p == null) {
                throw new AssemblerException(root, "Unknown personality: '" + personalityName + "'. Must be one of the following:\n" + String.join((CharSequence)"\n", Components.BUILTIN_PERSONALITIES.keySet()));
            }
        } else {
            p = Objects.requireNonNull(Components.BUILTIN_PERSONALITIES.get("OWL2_DL_PERSONALITY"));
        }
        ReasonerFactory r = this.getReasonerFactory(a, root);
        return new OntSpecification(p, r);
    }

    private ReasonerFactory getReasonerFactory(Assembler a, Resource root) {
        Resource rf = OntSpecificationAssembler.getUniqueResource((Resource)root, (Property)OA.reasonerFactory);
        Resource ru = OntSpecificationAssembler.getUniqueResource((Resource)root, (Property)OA.reasonerURL);
        if (ru != null && rf != null) {
            throw new ReasonerClashException(root);
        }
        if (ru != null) {
            return ReasonerFactoryAssembler.getReasonerFactoryByURL((Resource)root, (Resource)ru);
        }
        return rf == null ? null : (ReasonerFactory)a.open(rf);
    }

    private static String getLiteralString(Resource root, Property p) {
        Statement s = root.getProperty(p);
        if (s == null) {
            return null;
        }
        if (!s.getObject().isLiteral()) {
            throw new AssemblerException(root, "Invalid string property: " + String.valueOf(p));
        }
        return s.getString().trim();
    }

    private static class Components {
        private static final Map<String, OntPersonality> BUILTIN_PERSONALITIES = Map.of("OWL2_EL_PERSONALITY", OntPersonalities.OWL2_EL_PERSONALITY, "OWL2_RL_PERSONALITY", OntPersonalities.OWL2_RL_PERSONALITY, "OWL1_LITE_PERSONALITY", OntPersonalities.OWL1_LITE_PERSONALITY, "OWL2_DL_PERSONALITY", OntPersonalities.OWL2_DL_PERSONALITY, "OWL1_DL_PERSONALITY", OntPersonalities.OWL1_DL_PERSONALITY, "RDFS_PERSONALITY", OntPersonalities.RDFS_PERSONALITY, "OWL1_FULL_PERSONALITY", OntPersonalities.OWL1_FULL_PERSONALITY, "OWL2_QL_PERSONALITY", OntPersonalities.OWL2_QL_PERSONALITY, "OWL2_FULL_PERSONALITY", OntPersonalities.OWL2_FULL_PERSONALITY);
        private static final Map<String, OntSpecification> BUILTIN_SPECIFICATIONS = Map.ofEntries(Map.entry("OWL1_FULL_MEM", OntSpecification.OWL1_FULL_MEM), Map.entry("OWL2_RL_MEM_RDFS_INF", OntSpecification.OWL2_RL_MEM_RDFS_INF), Map.entry("OWL1_DL_MEM_RULES_INF", OntSpecification.OWL1_DL_MEM_RULES_INF), Map.entry("OWL1_LITE_MEM_TRANS_INF", OntSpecification.OWL1_LITE_MEM_TRANS_INF), Map.entry("OWL1_FULL_MEM_RDFS_INF", OntSpecification.OWL1_FULL_MEM_RDFS_INF), Map.entry("OWL1_FULL_MEM_MINI_RULES_INF", OntSpecification.OWL1_FULL_MEM_MINI_RULES_INF), Map.entry("OWL2_RL_MEM", OntSpecification.OWL2_RL_MEM), Map.entry("RDFS_MEM", OntSpecification.RDFS_MEM), Map.entry("OWL2_RL_MEM_RULES_INF", OntSpecification.OWL2_RL_MEM_RULES_INF), Map.entry("OWL2_DL_MEM_RDFS_INF", OntSpecification.OWL2_DL_MEM_RDFS_INF), Map.entry("OWL1_FULL_MEM_RULES_INF", OntSpecification.OWL1_FULL_MEM_RULES_INF), Map.entry("OWL2_FULL_MEM_RULES_INF", OntSpecification.OWL2_FULL_MEM_RULES_INF), Map.entry("OWL2_FULL_MEM", OntSpecification.OWL2_FULL_MEM), Map.entry("OWL2_FULL_MEM_MICRO_RULES_INF", OntSpecification.OWL2_FULL_MEM_MICRO_RULES_INF), Map.entry("OWL2_FULL_MEM_MINI_RULES_INF", OntSpecification.OWL2_FULL_MEM_MINI_RULES_INF), Map.entry("OWL2_QL_MEM_RDFS_INF", OntSpecification.OWL2_QL_MEM_RDFS_INF), Map.entry("OWL1_FULL_MEM_TRANS_INF", OntSpecification.OWL1_FULL_MEM_TRANS_INF), Map.entry("OWL1_FULL_MEM_MICRO_RULES_INF", OntSpecification.OWL1_FULL_MEM_MICRO_RULES_INF), Map.entry("OWL1_DL_MEM_TRANS_INF", OntSpecification.OWL1_DL_MEM_TRANS_INF), Map.entry("OWL2_FULL_MEM_TRANS_INF", OntSpecification.OWL2_FULL_MEM_TRANS_INF), Map.entry("OWL1_LITE_MEM", OntSpecification.OWL1_LITE_MEM), Map.entry("OWL2_EL_MEM_RULES_INF", OntSpecification.OWL2_EL_MEM_RULES_INF), Map.entry("OWL1_DL_MEM_RDFS_INF", OntSpecification.OWL1_DL_MEM_RDFS_INF), Map.entry("RDFS_MEM_TRANS_INF", OntSpecification.RDFS_MEM_TRANS_INF), Map.entry("OWL2_DL_MEM", OntSpecification.OWL2_DL_MEM), Map.entry("OWL2_EL_MEM_RDFS_INF", OntSpecification.OWL2_EL_MEM_RDFS_INF), Map.entry("OWL2_DL_MEM_TRANS_INF", OntSpecification.OWL2_DL_MEM_TRANS_INF), Map.entry("OWL2_FULL_MEM_RDFS_INF", OntSpecification.OWL2_FULL_MEM_RDFS_INF), Map.entry("OWL2_EL_MEM", OntSpecification.OWL2_EL_MEM), Map.entry("OWL2_EL_MEM_TRANS_INF", OntSpecification.OWL2_EL_MEM_TRANS_INF), Map.entry("OWL2_DL_MEM_RULES_INF", OntSpecification.OWL2_DL_MEM_RULES_INF), Map.entry("OWL2_QL_MEM_TRANS_INF", OntSpecification.OWL2_QL_MEM_TRANS_INF), Map.entry("OWL1_LITE_MEM_RDFS_INF", OntSpecification.OWL1_LITE_MEM_RDFS_INF), Map.entry("OWL1_LITE_MEM_RULES_INF", OntSpecification.OWL1_LITE_MEM_RULES_INF), Map.entry("OWL1_DL_MEM", OntSpecification.OWL1_DL_MEM), Map.entry("OWL2_DL_MEM_BUILTIN_RDFS_INF", OntSpecification.OWL2_DL_MEM_BUILTIN_RDFS_INF), Map.entry("OWL2_QL_MEM", OntSpecification.OWL2_QL_MEM), Map.entry("RDFS_MEM_RDFS_INF", OntSpecification.RDFS_MEM_RDFS_INF), Map.entry("OWL2_RL_MEM_TRANS_INF", OntSpecification.OWL2_RL_MEM_TRANS_INF), Map.entry("OWL2_QL_MEM_RULES_INF", OntSpecification.OWL2_QL_MEM_RULES_INF));

        private Components() {
        }
    }
}

