/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.store.xloader;

import java.io.Closeable;
import java.io.OutputStream;
import java.util.List;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.atlas.lib.Timer;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.system.AsyncParser;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.system.progress.ProgressMonitor;
import org.apache.jena.system.progress.ProgressMonitorOutput;
import org.apache.jena.tdb1.TDB1;
import org.apache.jena.tdb1.base.file.Location;
import org.apache.jena.tdb1.setup.DatasetBuilderStd;
import org.apache.jena.tdb1.solver.stats.Stats;
import org.apache.jena.tdb1.solver.stats.StatsCollectorNodeId;
import org.apache.jena.tdb1.store.DatasetGraphTDB;
import org.apache.jena.tdb1.store.NodeId;
import org.apache.jena.tdb1.store.bulkloader.BulkLoader;
import org.apache.jena.tdb1.store.bulkloader.BulkStreamRDF;
import org.apache.jena.tdb1.store.nodetable.NodeTable;
import org.apache.jena.tdb1.store.nodetupletable.NodeTupleTable;
import org.apache.jena.tdb1.store.xloader.WriteRows;
import org.apache.jena.tdb1.sys.TDBInternal;
import org.slf4j.Logger;

public class ProcNodeTableDataBuilder {
    private static Logger cmdLog = TDB1.logLoader;

    public static void exec(Location location, String dataFileTriples, String dataFileQuads, List<String> datafiles, boolean collectStats) {
        DatasetGraphTDB dsg = DatasetBuilderStd.create(location);
        dsg.getTripleTable().getNodeTupleTable().getTupleTable().close();
        dsg.getQuadTable().getNodeTupleTable().getTupleTable().close();
        ProgressMonitorOutput monitor = ProgressMonitorOutput.create((Logger)cmdLog, (String)"Data", (long)BulkLoader.DataTickPoint, (int)BulkLoader.superTick);
        OutputStream outputTriples = IO.openOutputFile((String)dataFileTriples);
        OutputStream outputQuads = IO.openOutputFile((String)dataFileQuads);
        ProcNodeTableDataBuilder.build((DatasetGraph)dsg, (ProgressMonitor)monitor, outputTriples, outputQuads, datafiles);
        TDBInternal.expel((DatasetGraph)dsg);
    }

    private static void build(DatasetGraph dsg, ProgressMonitor monitor, OutputStream outputTriples, OutputStream outputQuads, List<String> datafiles) {
        Location location;
        DatasetGraphTDB dsgtdb = TDBInternal.getDatasetGraphTDB(dsg);
        NodeTableBuilder sink = new NodeTableBuilder(dsgtdb, monitor, outputTriples, outputQuads, false);
        Timer timer = new Timer();
        timer.startTimer();
        monitor.start();
        sink.startBulk();
        AsyncParser.asyncParse(datafiles, (StreamRDF)sink);
        sink.finishBulk();
        IO.close((Closeable)outputTriples);
        IO.close((Closeable)outputQuads);
        if (sink.getCollector() != null && !(location = dsgtdb.getLocation()).isMem()) {
            Stats.write(location.getPath("stats.opt"), sink.getCollector().results());
        }
        monitor.finish();
        long time = timer.endTimer();
        long total = monitor.getTicks();
        float elapsedSecs = (float)time / 1000.0f;
        float rate = elapsedSecs != 0.0f ? (float)total / elapsedSecs : 0.0f;
        String str = String.format("Total: %,d tuples : %,.2f seconds : %,.2f tuples/sec [%s]", total, Float.valueOf(elapsedSecs), Float.valueOf(rate), DateTimeUtils.nowAsString());
        cmdLog.info(str);
    }

    static class NodeTableBuilder
    implements BulkStreamRDF {
        private DatasetGraphTDB dsg;
        private NodeTable nodeTable;
        private WriteRows writerTriples;
        private WriteRows writerQuads;
        private ProgressMonitor monitor;
        private StatsCollectorNodeId stats;

        NodeTableBuilder(DatasetGraphTDB dsg, ProgressMonitor monitor, OutputStream outputTriples, OutputStream outputQuads, boolean collectStats) {
            this.dsg = dsg;
            this.monitor = monitor;
            NodeTupleTable ntt = dsg.getTripleTable().getNodeTupleTable();
            this.nodeTable = ntt.getNodeTable();
            this.writerTriples = new WriteRows(outputTriples, 3, 20000);
            this.writerQuads = new WriteRows(outputQuads, 4, 20000);
            if (collectStats) {
                this.stats = new StatsCollectorNodeId(this.nodeTable);
            }
        }

        @Override
        public void startBulk() {
        }

        public void start() {
        }

        public void finish() {
        }

        @Override
        public void finishBulk() {
            this.writerTriples.flush();
            this.writerQuads.flush();
            this.nodeTable.sync();
            this.dsg.getStoragePrefixes().sync();
        }

        public void triple(Triple triple) {
            Node s = triple.getSubject();
            Node p = triple.getPredicate();
            Node o = triple.getObject();
            this.process(Quad.tripleInQuad, s, p, o);
        }

        public void quad(Quad quad) {
            Node s = quad.getSubject();
            Node p = quad.getPredicate();
            Node o = quad.getObject();
            Node g = null;
            if (!quad.isTriple() && !quad.isDefaultGraph()) {
                g = quad.getGraph();
            }
            this.process(g, s, p, o);
        }

        private void process(Node g, Node s, Node p, Node o) {
            NodeId sId = this.nodeTable.getAllocateNodeId(s);
            NodeId pId = this.nodeTable.getAllocateNodeId(p);
            NodeId oId = this.nodeTable.getAllocateNodeId(o);
            if (g != null) {
                NodeId gId = this.nodeTable.getAllocateNodeId(g);
                this.writerQuads.write(gId.getId());
                this.writerQuads.write(sId.getId());
                this.writerQuads.write(pId.getId());
                this.writerQuads.write(oId.getId());
                this.writerQuads.endOfRow();
                if (this.stats != null) {
                    this.stats.record(gId, sId, pId, oId);
                }
            } else {
                this.writerTriples.write(sId.getId());
                this.writerTriples.write(pId.getId());
                this.writerTriples.write(oId.getId());
                this.writerTriples.endOfRow();
                if (this.stats != null) {
                    this.stats.record((Object)null, sId, pId, oId);
                }
            }
            this.monitor.tick();
        }

        public StatsCollectorNodeId getCollector() {
            return this.stats;
        }

        public void base(String base) {
        }

        public void prefix(String prefix, String iri) {
            this.dsg.getStoragePrefixes().getPrefixMap().add(prefix, iri);
        }

        public void version(String version) {
        }
    }
}

