/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.context;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.StringUtils;
import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.json.JsonProvider;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.BlankNode;
import com.apicatalog.jsonld.lang.DirectionType;
import com.apicatalog.jsonld.lang.Keywords;
import com.apicatalog.jsonld.lang.LanguageTag;
import com.apicatalog.jsonld.loader.DocumentLoaderOptions;
import com.apicatalog.jsonld.uri.UriResolver;
import com.apicatalog.jsonld.uri.UriUtils;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ActiveContextBuilder {
    private static final int MAX_REMOTE_CONTEXTS = 256;
    private static final Logger LOGGER = Logger.getLogger(ActiveContextBuilder.class.getName());
    private final ActiveContext activeContext;
    private Collection<String> remoteContexts;
    private boolean overrideProtected;
    private boolean propagate;
    private boolean validateScopedContext;
    private ActiveContext result;

    private ActiveContextBuilder(ActiveContext activeContext) {
        this.activeContext = activeContext;
        this.remoteContexts = new ArrayList<String>();
        this.overrideProtected = false;
        this.propagate = true;
        this.validateScopedContext = true;
        this.result = null;
    }

    public static final ActiveContextBuilder with(ActiveContext activeContext) {
        return new ActiveContextBuilder(activeContext);
    }

    public ActiveContextBuilder remoteContexts(Collection<String> value) {
        this.remoteContexts = value;
        return this;
    }

    public ActiveContextBuilder overrideProtected(boolean value) {
        this.overrideProtected = value;
        return this;
    }

    public ActiveContextBuilder propagate(boolean value) {
        this.propagate = value;
        return this;
    }

    public ActiveContextBuilder validateScopedContext(boolean value) {
        this.validateScopedContext = value;
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public ActiveContext create(JsonValue localContext, URI baseUrl) throws JsonLdError {
        this.result = new ActiveContext(this.activeContext);
        this.result.setInverseContext(null);
        if (JsonUtils.isObject(localContext) && (propagateValue = (JsonValue)localContext.asJsonObject().get((Object)"@propagate")) != null) {
            if (JsonUtils.isNotBoolean(propagateValue)) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_PROPAGATE_VALUE);
            }
            this.propagate = JsonUtils.isTrue(propagateValue);
        }
        if (!this.propagate && this.result.getPreviousContext() == null) {
            this.result.setPreviousContext(this.activeContext);
        }
        for (JsonValue itemContext : JsonUtils.toCollection(localContext)) {
            block51: {
                block52: {
                    block49: {
                        block50: {
                            block46: {
                                block48: {
                                    block47: {
                                        if (JsonUtils.isNull(itemContext)) {
                                            if (!this.overrideProtected && this.result.containsProtectedTerm()) {
                                                throw new JsonLdError(JsonLdErrorCode.INVALID_CONTEXT_NULLIFICATION);
                                            }
                                            this.result = this.propagate != false ? new ActiveContext(this.activeContext.getBaseUrl(), this.activeContext.getBaseUrl(), this.activeContext.runtime()) : new ActiveContext(this.activeContext.getBaseUrl(), this.activeContext.getBaseUrl(), this.result.getPreviousContext(), this.activeContext.runtime());
                                            continue;
                                        }
                                        if (JsonUtils.isString(itemContext)) {
                                            this.fetch(((JsonString)itemContext).getString(), baseUrl);
                                            continue;
                                        }
                                        if (JsonUtils.isNotObject(itemContext)) {
                                            throw new JsonLdError(JsonLdErrorCode.INVALID_LOCAL_CONTEXT);
                                        }
                                        contextDefinition = itemContext.asJsonObject();
                                        version = (JsonValue)contextDefinition.get((Object)"@version");
                                        if (version != null) {
                                            versionString = null;
                                            if (JsonUtils.isString(version)) {
                                                versionString = ((JsonString)version).getString();
                                            } else if (JsonUtils.isNumber(version)) {
                                                versionString = version.toString();
                                            }
                                            if (!"1.1".equals(versionString)) {
                                                throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_VERSION_VALUE);
                                            }
                                            if (this.activeContext.runtime().isV10()) {
                                                throw new JsonLdError(JsonLdErrorCode.PROCESSING_MODE_CONFLICT);
                                            }
                                        }
                                        if (contextDefinition.containsKey((Object)"@import")) {
                                            if (this.activeContext.runtime().isV10()) {
                                                throw new JsonLdError(JsonLdErrorCode.INVALID_CONTEXT_ENTRY);
                                            }
                                            contextImport = (JsonValue)contextDefinition.get((Object)"@import");
                                            if (JsonUtils.isNotString(contextImport)) {
                                                throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_IMPORT_VALUE, "Invalid context @import value [" + contextImport + "].");
                                            }
                                            contextImportUri = UriResolver.resolveAsUri(baseUrl, ((JsonString)contextImport).getString());
                                            if (this.activeContext.runtime().getDocumentLoader() == null) {
                                                throw new JsonLdError(JsonLdErrorCode.LOADING_REMOTE_CONTEXT_FAILED);
                                            }
                                            loaderOptions = new DocumentLoaderOptions();
                                            loaderOptions.setProfile("http://www.w3.org/ns/json-ld#context");
                                            loaderOptions.setRequestProfile(Arrays.asList(new String[]{loaderOptions.getProfile()}));
                                            importedStructure = null;
                                            try {
                                                importedDocument = this.activeContext.runtime().getDocumentLoader().loadDocument(contextImportUri, loaderOptions);
                                                if (importedDocument == null) {
                                                    throw new JsonLdError(JsonLdErrorCode.INVALID_REMOTE_CONTEXT, "Imported context[" + contextImportUri + "] is null.");
                                                }
                                                importedStructure = importedDocument.getJsonContent().orElseThrow((Supplier<JsonLdError>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$create$0(), ()Lcom/apicatalog/jsonld/JsonLdError;)());
                                            }
                                            catch (JsonLdError e) {
                                                throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_IMPORT_VALUE, (Throwable)e);
                                            }
                                            if (JsonUtils.isNotObject((JsonValue)importedStructure)) {
                                                throw new JsonLdError(JsonLdErrorCode.INVALID_REMOTE_CONTEXT);
                                            }
                                            importedContext = (JsonValue)importedStructure.asJsonObject().get((Object)"@context");
                                            if (importedContext == null || JsonUtils.isNotObject(importedContext)) {
                                                throw new JsonLdError(JsonLdErrorCode.INVALID_REMOTE_CONTEXT);
                                            }
                                            importedContextObject = importedContext.asJsonObject();
                                            if (importedContextObject.containsKey((Object)"@import")) {
                                                throw new JsonLdError(JsonLdErrorCode.INVALID_CONTEXT_ENTRY);
                                            }
                                            contextDefinition = JsonUtils.merge(importedContextObject, contextDefinition);
                                        }
                                        if (!contextDefinition.containsKey((Object)"@base")) break block46;
                                        value = (JsonValue)contextDefinition.get((Object)"@base");
                                        if (!JsonUtils.isNull(value)) break block47;
                                        this.result.setBaseUri(null);
                                        break block46;
                                    }
                                    if (!JsonUtils.isString(value)) break block48;
                                    valueString = ((JsonString)value).getString();
                                    v0 = valueUri = StringUtils.isNotBlank(valueString) != false ? UriUtils.create(valueString) : null;
                                    if (valueUri == null) ** GOTO lbl81
                                    if (valueUri.isAbsolute()) {
                                        this.result.setBaseUri(valueUri);
                                    } else if (this.result.getBaseUri() != null) {
                                        this.result.setBaseUri(UriResolver.resolveAsUri(this.result.getBaseUri(), valueUri));
                                    } else {
                                        ActiveContextBuilder.LOGGER.log(Level.FINE, "5.7.4: valueString={0}, localContext={1}, baseUrl={2}", new Object[]{valueString, localContext, baseUrl});
                                        throw new JsonLdError(JsonLdErrorCode.INVALID_BASE_IRI, "A relative base IRI cannot be resolved [@base = " + valueString + "]. Please use JsonLdOptions.setBase() method to set an absolute IRI.");
lbl81:
                                        // 1 sources

                                        if (StringUtils.isNotBlank(valueString)) {
                                            throw new JsonLdError(JsonLdErrorCode.INVALID_BASE_IRI, "An invalid base IRI has been detected [@base = " + valueString + "].");
                                        }
                                    }
                                    break block46;
                                }
                                throw new JsonLdError(JsonLdErrorCode.INVALID_BASE_IRI, "An invalid base IRI has been detected [@base = " + value + "].");
                            }
                            if (!contextDefinition.containsKey((Object)"@vocab")) break block49;
                            value = (JsonValue)contextDefinition.get((Object)"@vocab");
                            if (!JsonUtils.isNull(value)) break block50;
                            this.result.setVocabularyMapping(null);
                            break block49;
                        }
                        if (!JsonUtils.isString(value)) ** GOTO lbl102
                        valueString = ((JsonString)value).getString();
                        if (!StringUtils.isBlank(valueString) && !BlankNode.hasPrefix(valueString) && !UriUtils.isURI(valueString)) ** GOTO lbl101
                        vocabularyMapping = this.result.uriExpansion().vocab(true).documentRelative(true).expand(valueString);
                        if (BlankNode.hasPrefix(valueString) || UriUtils.isURI(vocabularyMapping)) {
                            this.result.setVocabularyMapping(vocabularyMapping);
                        } else {
                            throw new JsonLdError(JsonLdErrorCode.INVALID_VOCAB_MAPPING, "An invalid vocabulary mapping [" + vocabularyMapping + "] has been detected.");
lbl101:
                            // 1 sources

                            throw new JsonLdError(JsonLdErrorCode.INVALID_VOCAB_MAPPING, "An invalid vocabulary mapping [" + valueString + "] has been detected.");
lbl102:
                            // 1 sources

                            throw new JsonLdError(JsonLdErrorCode.INVALID_VOCAB_MAPPING);
                        }
                    }
                    if (contextDefinition.containsKey((Object)"@language")) {
                        value = (JsonValue)contextDefinition.get((Object)"@language");
                        if (JsonUtils.isNull(value)) {
                            this.result.setDefaultLanguage(null);
                        } else if (JsonUtils.isString(value)) {
                            this.result.setDefaultLanguage(((JsonString)value).getString());
                            if (!LanguageTag.isWellFormed(this.result.getDefaultLanguage())) {
                                ActiveContextBuilder.LOGGER.log(Level.WARNING, "Language tag [{0}] is not well formed.", this.result.getDefaultLanguage());
                            }
                        } else {
                            throw new JsonLdError(JsonLdErrorCode.INVALID_DEFAULT_LANGUAGE);
                        }
                    }
                    if (!contextDefinition.containsKey((Object)"@direction")) break block51;
                    if (this.activeContext.runtime().isV10()) {
                        throw new JsonLdError(JsonLdErrorCode.INVALID_CONTEXT_ENTRY);
                    }
                    value = (JsonValue)contextDefinition.get((Object)"@direction");
                    if (!JsonUtils.isNull(value)) break block52;
                    this.result.setDefaultBaseDirection(DirectionType.NULL);
                    break block51;
                }
                if (!JsonUtils.isString(value)) ** GOTO lbl132
                direction = ((JsonString)value).getString();
                if ("ltr".equalsIgnoreCase(direction)) {
                    this.result.setDefaultBaseDirection(DirectionType.LTR);
                } else if ("rtl".equalsIgnoreCase(direction)) {
                    this.result.setDefaultBaseDirection(DirectionType.RTL);
                } else {
                    throw new JsonLdError(JsonLdErrorCode.INVALID_BASE_DIRECTION);
lbl132:
                    // 1 sources

                    throw new JsonLdError(JsonLdErrorCode.INVALID_BASE_DIRECTION);
                }
            }
            if (contextDefinition.containsKey((Object)"@propagate")) {
                if (this.activeContext.runtime().isV10()) {
                    throw new JsonLdError(JsonLdErrorCode.INVALID_CONTEXT_ENTRY);
                }
                if (JsonUtils.isNotBoolean((JsonValue)contextDefinition.get((Object)"@propagate"))) {
                    throw new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_PROPAGATE_VALUE);
                }
            }
            termBuilder = this.result.newTerm(contextDefinition, new HashMap<String, Boolean>()).baseUrl(baseUrl).overrideProtectedFlag(this.overrideProtected);
            for (String key : contextDefinition.keySet()) {
                if (!Keywords.noneMatch(key, new String[]{"@base", "@direction", "@import", "@language", "@propagate", "@protected", "@version", "@vocab"})) continue;
                termBuilder.protectedFlag(JsonUtils.isTrue((JsonValue)contextDefinition.get((Object)"@protected"))).remoteContexts(new ArrayList<String>(this.remoteContexts)).create(key);
            }
        }
        return this.result;
    }

    private void fetch(String context, URI baseUrl) throws JsonLdError {
        JsonStructure importedStructure;
        URI contextUri;
        try {
            contextUri = URI.create(context);
            if (baseUrl != null) {
                contextUri = UriResolver.resolveAsUri(baseUrl, contextUri);
            }
            if (!contextUri.isAbsolute()) {
                throw new JsonLdError(JsonLdErrorCode.LOADING_REMOTE_CONTEXT_FAILED, "Context URI is not absolute [" + contextUri + "].");
            }
        }
        catch (IllegalArgumentException e) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_REMOTE_CONTEXT_FAILED, "Context URI is not URI [" + context + "].");
        }
        String contextKey = contextUri.toString();
        if (!this.validateScopedContext && this.remoteContexts.contains(contextKey)) {
            return;
        }
        if (this.remoteContexts.size() > 256) {
            throw new JsonLdError(JsonLdErrorCode.CONTEXT_OVERFLOW, "Too many contexts [>256].");
        }
        this.remoteContexts.add(contextKey);
        if (this.activeContext.runtime().getContextCache() != null && this.activeContext.runtime().getContextCache().containsKey(contextKey) && !this.validateScopedContext) {
            JsonValue cachedContext = this.activeContext.runtime().getContextCache().get(contextKey);
            this.result = this.result.newContext().remoteContexts(new ArrayList<String>(this.remoteContexts)).validateScopedContext(this.validateScopedContext).create(cachedContext, contextUri);
            return;
        }
        if (this.activeContext.runtime().getDocumentLoader() == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_REMOTE_CONTEXT_FAILED, "Document loader is null. Cannot fetch [" + contextUri + "].");
        }
        Document remoteImport = null;
        if (this.activeContext.runtime().getDocumentCache() != null && this.activeContext.runtime().getDocumentCache().containsKey(contextKey)) {
            remoteImport = this.activeContext.runtime().getDocumentCache().get(contextKey);
        }
        if (remoteImport == null) {
            DocumentLoaderOptions loaderOptions = new DocumentLoaderOptions();
            loaderOptions.setProfile("http://www.w3.org/ns/json-ld#context");
            loaderOptions.setRequestProfile(Arrays.asList(loaderOptions.getProfile()));
            try {
                remoteImport = this.activeContext.runtime().getDocumentLoader().loadDocument(contextUri, loaderOptions);
            }
            catch (JsonLdError e) {
                throw new JsonLdError(JsonLdErrorCode.LOADING_REMOTE_CONTEXT_FAILED, "There was a problem encountered loading a remote context [" + contextUri + "]", e);
            }
            if (remoteImport == null) {
                throw new JsonLdError(JsonLdErrorCode.INVALID_REMOTE_CONTEXT, "Imported context is null.");
            }
        }
        if (JsonUtils.isNotObject((JsonValue)(importedStructure = remoteImport.getJsonContent().orElseThrow(() -> new JsonLdError(JsonLdErrorCode.INVALID_REMOTE_CONTEXT, "Imported context is null."))))) {
            throw new JsonLdError(JsonLdErrorCode.INVALID_REMOTE_CONTEXT, "Imported context is not valid Json Object [" + importedStructure.getValueType() + "].");
        }
        JsonObject importedContext = importedStructure.asJsonObject();
        if (!importedContext.asJsonObject().containsKey((Object)"@context")) {
            throw new JsonLdError(JsonLdErrorCode.INVALID_REMOTE_CONTEXT, "Imported context does not contain @context key and is not valid JSON-LD context.");
        }
        if (JsonUtils.containsKey((JsonValue)(importedContext = (JsonValue)importedContext.asJsonObject().get((Object)"@context")), "@base")) {
            importedContext = JsonProvider.instance().createObjectBuilder(importedContext.asJsonObject()).remove("@base").build();
        }
        if (this.activeContext.runtime().getDocumentCache() != null) {
            this.activeContext.runtime().getDocumentCache().put(contextKey, remoteImport);
        }
        try {
            this.result = this.result.newContext().remoteContexts(new ArrayList<String>(this.remoteContexts)).validateScopedContext(this.validateScopedContext).create((JsonValue)importedContext, remoteImport.getDocumentUrl());
            if (this.result.runtime().getContextCache() != null && !this.validateScopedContext) {
                this.result.runtime().getContextCache().put(contextKey, (JsonValue)importedContext);
            }
        }
        catch (JsonLdError e) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_REMOTE_CONTEXT_FAILED, (Throwable)e);
        }
    }

    private static /* synthetic */ JsonLdError lambda$create$0() {
        return new JsonLdError(JsonLdErrorCode.INVALID_KEYWORD_IMPORT_VALUE);
    }
}

