/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store.nodetupletable;

import java.util.Iterator;
import org.apache.jena.atlas.lib.ArrayUtils;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.graph.Node;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.nodetupletable.NodeTupleTable;
import org.apache.jena.tdb2.store.nodetupletable.NodeTupleTableWrapper;
import org.apache.jena.tdb2.store.tupletable.TupleTable;

public class NodeTupleTableView
extends NodeTupleTableWrapper {
    private Node prefix;
    private NodeId prefixId;

    public NodeTupleTableView(NodeTupleTable ntt, Node prefix) {
        super(ntt);
        this.prefix = prefix;
        this.prefixId = ntt.getNodeTable().getNodeIdForNode(prefix);
    }

    @Override
    public void addRow(Node ... nodes) {
        nodes = NodeTupleTableView.push(Node.class, this.prefix, nodes);
        super.addRow(nodes);
    }

    @Override
    public void deleteRow(Node ... nodes) {
        nodes = NodeTupleTableView.push(Node.class, this.prefix, nodes);
        super.deleteRow(nodes);
    }

    @Override
    public Iterator<Tuple<Node>> find(Node ... nodes) {
        nodes = NodeTupleTableView.push(Node.class, this.prefix, nodes);
        return this.nodeTupleTable.find(nodes);
    }

    private static <T> T[] push(Class<T> cls, T x, T[] array) {
        Object[] array2 = ArrayUtils.alloc(cls, (int)(array.length + 1));
        System.arraycopy(array, 0, array2, 1, array.length);
        array2[0] = x;
        return array2;
    }

    private static <T> T[] push(Class<T> cls, T x, Tuple<T> tuple) {
        Object[] array2 = ArrayUtils.alloc(cls, (int)(tuple.len() + 1));
        tuple.copyInto(array2, 1);
        array2[0] = x;
        return array2;
    }

    @Override
    public Iterator<Tuple<NodeId>> find(NodeId ... ids) {
        ids = NodeTupleTableView.push(NodeId.class, this.prefixId, ids);
        return this.nodeTupleTable.find(ids);
    }

    @Override
    public Iterator<Tuple<NodeId>> find(Tuple<NodeId> ids) {
        NodeId[] ids2 = NodeTupleTableView.push(NodeId.class, this.prefixId, ids);
        return this.nodeTupleTable.find(ids2);
    }

    @Override
    public Iterator<Tuple<NodeId>> findAsNodeIds(Node ... nodes) {
        nodes = NodeTupleTableView.push(Node.class, this.prefix, nodes);
        return this.nodeTupleTable.findAsNodeIds(nodes);
    }

    @Override
    public TupleTable getTupleTable() {
        return super.getTupleTable();
    }
}

