/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.model;

import java.util.Objects;
import java.util.stream.Stream;
import org.apache.jena.ontapi.model.OntClass;
import org.apache.jena.ontapi.model.OntNegativeAssertion;
import org.apache.jena.ontapi.model.OntObject;
import org.apache.jena.ontapi.model.OntProperty;
import org.apache.jena.ontapi.model.OntStatement;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.vocabulary.OWL2;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public interface OntRelationalProperty
extends OntProperty {
    public Stream<? extends OntRelationalProperty> subProperties(boolean var1);

    public Stream<? extends OntRelationalProperty> superProperties(boolean var1);

    public Stream<? extends OntObject> ranges();

    public Stream<? extends OntRelationalProperty> subProperties();

    public Stream<? extends OntRelationalProperty> superProperties();

    public Stream<? extends OntRelationalProperty> disjointProperties();

    public Stream<? extends OntRelationalProperty> equivalentProperties();

    public Stream<? extends OntNegativeAssertion<?, ?>> negativeAssertions();

    public OntRelationalProperty addDomain(OntClass var1);

    @Override
    public OntRelationalProperty removeDomain(Resource var1);

    @Override
    public OntRelationalProperty removeRange(Resource var1);

    @Override
    public OntRelationalProperty removeSuperProperty(Resource var1);

    public OntRelationalProperty removeEquivalentProperty(Resource var1);

    public OntRelationalProperty removeDisjointProperty(Resource var1);

    default public Stream<OntClass.Restriction> referringRestrictions() {
        return Stream.concat(this.getModel().statements(null, OWL2.onProperty, (RDFNode)this).map(it -> it.getSubject().getAs(OntClass.UnaryRestriction.class)).filter(Objects::nonNull), this.getModel().statements(null, OWL2.onProperties, null).map(it -> it.getSubject().getAs(OntClass.NaryRestriction.class)).filter(Objects::nonNull).filter(it -> it.getList().contains(this)));
    }

    default public Stream<OntClass> domains() {
        return this.objects(RDFS.domain, OntClass.class).filter(OntClass::canAsSuperClass).map(OntClass::asSuperClass);
    }

    default public Stream<OntClass> domains(boolean direct) {
        if (direct) {
            return this.domains();
        }
        return this.domains().flatMap(d -> Stream.concat(Stream.of(d), d.superClasses(false))).distinct();
    }

    default public OntStatement addFunctionalDeclaration() {
        return this.addStatement(RDF.type, (RDFNode)OWL2.FunctionalProperty);
    }

    default public boolean isFunctional() {
        return this.hasType(OWL2.FunctionalProperty);
    }

    public OntRelationalProperty setFunctional(boolean var1);
}

